/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import ghidra.program.database.symbol.LibrarySymbol;
import ghidra.program.database.symbol.NamespaceManager;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Library;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

class LibraryDB
implements Library {
    private LibrarySymbol symbol;
    private NamespaceManager namespaceMgr;

    LibraryDB(LibrarySymbol symbol, NamespaceManager namespaceMgr) {
        this.symbol = symbol;
        this.namespaceMgr = namespaceMgr;
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public String getName() {
        return this.symbol.getName();
    }

    @Override
    public long getID() {
        return this.symbol.getID();
    }

    @Override
    public Namespace getParentNamespace() {
        return this.symbol.getParentNamespace();
    }

    @Override
    public AddressSetView getBody() {
        return this.namespaceMgr.getAddressSet(this);
    }

    @Override
    public String getName(boolean includeNamespacePath) {
        return this.symbol.getName(includeNamespacePath);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        LibraryDB lib = (LibraryDB)obj;
        return this.symbol == lib.symbol;
    }

    @Override
    public void setParentNamespace(Namespace parentNamespace) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        this.symbol.setNamespace(parentNamespace);
    }

    @Override
    public String getAssociatedProgramPath() {
        return this.symbol.getExternalLibraryPath();
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

