/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.utils;

import ghidra.util.BigEndianDataConverter;
import ghidra.util.LittleEndianDataConverter;
import java.math.BigInteger;

public class Utils {
    public static final String endl = System.getProperty("line.separator");
    private static long[] uintbmasks = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};

    public static BigInteger convertToSignedValue(BigInteger val, int byteSize) {
        int signbit = byteSize * 8 - 1;
        if (val.signum() < 0 || !val.testBit(signbit)) {
            return val;
        }
        return val.subtract(BigInteger.ONE.shiftLeft(signbit + 1));
    }

    public static BigInteger convertToUnsignedValue(BigInteger val, int byteSize) {
        if (val.signum() >= 0) {
            return val;
        }
        BigInteger mask = BigInteger.ONE.shiftLeft(byteSize * 8).subtract(BigInteger.ONE);
        return val.and(mask);
    }

    public static long calc_mask(int size) {
        return uintbmasks[size < 8 ? size : 8];
    }

    public static BigInteger calc_bigmask(int size) {
        return BigInteger.ONE.shiftLeft(size * 8).subtract(BigInteger.ONE);
    }

    public static boolean signbit_negative(long val, int size) {
        long mask = 128L;
        return (val & (mask <<= 8 * (size - 1))) != 0L;
    }

    public static long uintb_negate(long in, int size) {
        return (in ^ 0xFFFFFFFFFFFFFFFFL) & Utils.calc_mask(size);
    }

    public static long sign_extend(long in, int sizein, int sizeout) {
        int signbit = sizein * 8 - 1;
        in &= Utils.calc_mask(sizein);
        if (sizein >= sizeout) {
            return in;
        }
        if (in >>> signbit != 0L) {
            long mask = Utils.calc_mask(sizeout);
            long tmp = mask << signbit;
            tmp = tmp << 1 & mask;
            in |= tmp;
        }
        return in;
    }

    public static long zzz_sign_extend(long val, int bit) {
        long mask = 0L;
        mask = (mask ^ 0xFFFFFFFFFFFFFFFFL) << bit;
        val = (val >>> bit & 1L) != 0L ? (val |= mask) : (val &= mask ^ 0xFFFFFFFFFFFFFFFFL);
        return val;
    }

    public static long zzz_zero_extend(long val, int bit) {
        long mask = 0L;
        mask = (mask ^ 0xFFFFFFFFFFFFFFFFL) << bit;
        return val &= (mask <<= 1) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long byte_swap(long val, int size) {
        long res = 0L;
        while (size > 0) {
            res <<= 8;
            res |= val & 0xFFL;
            val >>>= 8;
            --size;
        }
        return res;
    }

    long byte_swap(int val) {
        long res = 0L;
        for (int i = 0; i < 4; ++i) {
            res <<= 8;
            res |= (long)(val & 0xFF);
            val >>>= 8;
        }
        return res;
    }

    public static long bytesToLong(byte[] byteBuf, int size, boolean bigEndian) {
        long value = 0L;
        for (int i = 0; i < size; ++i) {
            value = value << 8 | (long)(byteBuf[i] & 0xFF);
        }
        if (!bigEndian) {
            value = Utils.byte_swap(value, size);
        }
        return value;
    }

    public static byte[] longToBytes(long val, int size, boolean bigEndian) {
        long value = val;
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            int index = bigEndian ? size - i - 1 : i;
            bytes[index] = (byte)value;
            value >>= 8;
        }
        return bytes;
    }

    public static BigInteger bytesToBigInteger(byte[] byteBuf, int size, boolean bigEndian, boolean signed) {
        if (bigEndian) {
            return BigEndianDataConverter.INSTANCE.getBigInteger(byteBuf, size, signed);
        }
        return LittleEndianDataConverter.INSTANCE.getBigInteger(byteBuf, size, signed);
    }

    public static byte[] bigIntegerToBytes(BigInteger val, int size, boolean bigEndian) {
        if (bigEndian) {
            return BigEndianDataConverter.INSTANCE.getBytes(val, size);
        }
        return LittleEndianDataConverter.INSTANCE.getBytes(val, size);
    }
}

