/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sevenzip;

import ghidra.file.cliwrapper.AbstractCliToolWrapper;
import ghidra.file.cliwrapper.ArchiverCliToolWrapper;
import ghidra.file.cliwrapper.SemVer;
import ghidra.formats.gfilesystem.fileinfo.FileType;
import ghidra.framework.OperatingSystem;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SevenZipCliToolWrapper
extends AbstractCliToolWrapper
implements ArchiverCliToolWrapper {
    private static final SemVer MIN_SUPPORTED_VER = SemVer.parse("23.0");
    private static final List<String> NATIVE_UNIX_EXE_NAMES = List.of("7zz", "7zzs", "7z");
    private static final List<String> NATIVE_WIN_EXE_NAMES = List.of("7z.exe");
    private static final Pattern SZ_VER_PATTERN = Pattern.compile(".*7-Zip \\(z\\) ([0-9.]+) .*Copyright \\(c\\).*");
    private static final int DATETIME_START = 0;
    private static final int DATETIME_LEN = 19;
    private static final int ATTR_START = 20;
    private static final int ATTR_LEN = 5;
    private static final int SIZE_START = 26;
    private static final int SIZE_LEN = 12;
    private static final int COMPRESSED_START = 39;
    private static final int COMPRESSED_LEN = 12;
    private static final int NAME_START = 53;
    private SimpleDateFormat listingDateTimeFormat = new SimpleDateFormat("yyy-MM-dd HH:mm:ss");

    private static final List<String> getCurrentOSNativeExeNames() {
        return switch (OperatingSystem.CURRENT_OPERATING_SYSTEM) {
            case OperatingSystem.WINDOWS -> NATIVE_WIN_EXE_NAMES;
            default -> NATIVE_UNIX_EXE_NAMES;
        };
    }

    public static SevenZipCliToolWrapper findTool(TaskMonitor monitor) {
        return SevenZipCliToolWrapper.findToolWrapper(SevenZipCliToolWrapper.getCurrentOSNativeExeNames(), monitor, SevenZipCliToolWrapper::new);
    }

    public SevenZipCliToolWrapper(File nativeExecutable) {
        super(nativeExecutable);
    }

    @Override
    public boolean isValid(TaskMonitor monitor) {
        try {
            Matcher m;
            StringBuilder sb = new StringBuilder();
            if (this.execAndReadStdOut(List.of("--help"), monitor, sb::append) == 0 && (m = SZ_VER_PATTERN.matcher(sb.toString())).matches()) {
                SemVer ver = SemVer.parse(m.group(1));
                return ver != SemVer.INVALID && ver.compareTo(MIN_SUPPORTED_VER) >= 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void extract(File archiveFile, ArchiverCliToolWrapper.Entry entry, OutputStream os, TaskMonitor monitor) throws IOException {
        int exitVal = this.execAndRedirectStdOut(List.of("-so", "e", archiveFile.getPath(), entry.name()), null, os, monitor);
        if (exitVal != 0) {
            throw new IOException("Error during extraction: %s, retVal: %d".formatted(this.nativeExecutable, exitVal));
        }
    }

    @Override
    public List<ArchiverCliToolWrapper.Entry> getListing(File archiveFile, TaskMonitor monitor) {
        try {
            ArrayList lines = new ArrayList();
            if (this.execAndReadStdOut(List.of("l", archiveFile.getPath()), monitor, lines::add) != 0) {
                return List.of();
            }
            boolean inListingSection = false;
            ArrayList<ArchiverCliToolWrapper.Entry> results = new ArrayList<ArchiverCliToolWrapper.Entry>();
            for (int lineNum = 0; lineNum < lines.size(); ++lineNum) {
                String line = (String)lines.get(lineNum);
                if (this.isListingStartEndLine(line)) {
                    if (inListingSection) break;
                    inListingSection = true;
                    continue;
                }
                if (!inListingSection || line.length() < 53) continue;
                SevenZipListingLine ll = this.parseListingLine(line);
                results.add(new ArchiverCliToolWrapper.Entry(ll.name, ll.size, ll.fileType));
            }
            return results;
        }
        catch (IOException iOException) {
            return List.of();
        }
    }

    private SevenZipListingLine parseListingLine(String s) {
        String datetimeStr = s.substring(0, 19);
        String attrStr = s.substring(20, 25);
        String sizeStr = s.substring(26, 38);
        String compressedStr = s.substring(39, 51);
        String name = s.substring(53);
        long dateMS = SevenZipCliToolWrapper.parseDateElse(this.listingDateTimeFormat, datetimeStr, 0L);
        FileType fileType = this.parseAttrs(attrStr);
        long size = SevenZipCliToolWrapper.parseSize(sizeStr);
        long compressedSize = SevenZipCliToolWrapper.parseSize(compressedStr);
        return new SevenZipListingLine(dateMS, fileType, size, compressedSize, name);
    }

    private FileType parseAttrs(String s) {
        return s.length() == 5 && s.charAt(0) == 'D' ? FileType.DIRECTORY : FileType.FILE;
    }

    private static long parseSize(String s) {
        try {
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private static long parseDateElse(SimpleDateFormat sdf, String s, long defaultValue) {
        try {
            return sdf.parse(s).getTime();
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    private boolean isListingStartEndLine(String s) {
        String[] parts = s.split(" +");
        return parts.length == 5 && this.isAll(parts[0], "-") && this.isAll(parts[1], "-") && this.isAll(parts[2], "-") && this.isAll(parts[3], "-") && this.isAll(parts[4], "-");
    }

    private boolean isAll(String s, String ch) {
        return !s.isEmpty() && ch.repeat(s.length()).equals(s);
    }

    record SevenZipListingLine(long date, FileType fileType, long size, long compressedSize, String name) {
    }
}

