/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.gzip;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.gzip.GZipFileSystem;
import ghidra.file.formats.gzip.GZipUtil;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.io.FilenameUtils;

public class GZipFileSystemFactory
implements GFileSystemFactoryByteProvider<GZipFileSystem>,
GFileSystemProbeBytesOnly {
    public static final int PROBE_BYTES_REQUIRED = 2;
    public static final String GZIP_PAYLOAD_FILENAME = "gzip_decompressed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GZipFileSystem create(FSRLRoot targetFSRL, ByteProvider provider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        try {
            GZipFileSystem fs;
            String containerName = targetFSRL.getContainer().getName();
            FileAttributes payloadAttrs = this.getGZFileAttributes(provider, containerName);
            String payloadName = (String)payloadAttrs.get(FileAttributeType.NAME_ATTR, String.class, (Object)GZIP_PAYLOAD_FILENAME);
            UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, provider.length());
            ByteProvider payloadProvider = fsService.getDerivedByteProvider(provider.getFSRL(), null, "uncompressed " + payloadName, -1L, () -> new GzipCompressorInputStream(provider.getInputStream(0L)), (TaskMonitor)upwtm);
            payloadAttrs.add(FileAttributeType.SIZE_ATTR, (Object)payloadProvider.length());
            GZipFileSystem gZipFileSystem = fs = new GZipFileSystem(targetFSRL, payloadProvider, payloadName, payloadAttrs);
            return gZipFileSystem;
        }
        finally {
            FSUtilities.uncheckedClose((AutoCloseable)provider, null);
        }
    }

    private FileAttributes getGZFileAttributes(ByteProvider provider, String containerName) throws IOException {
        String payloadFilename = GZIP_PAYLOAD_FILENAME;
        String origComment = null;
        long origDate = 0L;
        try (GzipCompressorInputStream gzcis = new GzipCompressorInputStream(provider.getInputStream(0L));){
            GzipParameters metaData = gzcis.getMetaData();
            payloadFilename = metaData.getFileName();
            payloadFilename = payloadFilename == null ? (containerName.toLowerCase().endsWith(".gz") ? FilenameUtils.removeExtension((String)containerName) : GZIP_PAYLOAD_FILENAME) : FSUtilities.getSafeFilename((String)payloadFilename);
            origComment = metaData.getComment();
            origDate = metaData.getModificationTime();
        }
        return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.NAME_ATTR, (Object)payloadFilename), FileAttribute.create((FileAttributeType)FileAttributeType.COMPRESSED_SIZE_ATTR, (Object)provider.length()), FileAttribute.create((FileAttributeType)FileAttributeType.MODIFIED_DATE_ATTR, (Object)(origDate != 0L ? new Date(origDate) : null)), FileAttribute.create((FileAttributeType)FileAttributeType.COMMENT_ATTR, (Object)origComment)});
    }

    public int getBytesRequired() {
        return 2;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return GZipUtil.isGZip(startBytes);
    }
}

