/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.cliwrapper;

import java.util.Objects;

public record SemVer(int major, int minor, int patch) implements Comparable<SemVer>
{
    public static final SemVer INVALID = new SemVer(0, 0, 0);
    public static final SemVer ANY = new SemVer(-1, -1, -1);

    public static SemVer parse(String s) {
        return SemVer.parse(s, 0);
    }

    public static SemVer parseWildcardPatch(String s) {
        return SemVer.parse(s, -1);
    }

    private static SemVer parse(String s, int missingPatchValue) {
        String[] parts = Objects.requireNonNullElse(s, "").replaceAll("[^.0-9].*$", "").split("\\.");
        if (parts.length < 2) {
            return INVALID;
        }
        try {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            int patch = parts.length > 2 ? Integer.parseInt(parts[2]) : missingPatchValue;
            return new SemVer(major, minor, patch);
        }
        catch (NumberFormatException numberFormatException) {
            return INVALID;
        }
    }

    public boolean isInvalid() {
        return this.major == 0 && this.minor == 0;
    }

    public boolean isWildcard() {
        return this.major == -1 && this.minor == -1;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public SemVer prevPatch() {
        return new SemVer(this.major, this.minor, this.patch > 0 ? this.patch - 1 : 0);
    }

    public SemVer withPatch(int newPatchNum) {
        return new SemVer(this.major, this.minor, newPatchNum);
    }

    @Override
    public int compareTo(SemVer o) {
        int result = Integer.compare(this.major, o.major);
        if (result == 0) {
            result = Integer.compare(this.minor, o.minor);
        }
        if (result == 0) {
            result = this.patch == -1 || o.patch == -1 ? 0 : Integer.compare(this.patch, o.patch);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.patch != -1 ? "%d.%d.%d".formatted(this.major, this.minor, this.patch) : "%d.%d".formatted(this.major, this.minor);
    }
}

