/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GLabel;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ProgramByteViewerComponentProvider;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.util.AddressInput;
import ghidra.app.util.bean.FixedBitSizeValueField;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;

public class ByteViewerOptionsDialog
extends DialogComponentProvider
implements ChangeListener,
ActionListener {
    private AddressInput addressInputField;
    private FixedBitSizeValueField bytesPerLineField;
    private FixedBitSizeValueField groupSizeField;
    private ByteViewerComponentProvider provider;
    private Map<String, JCheckBox> checkboxMap = new HashMap<String, JCheckBox>();

    public ByteViewerOptionsDialog(ByteViewerComponentProvider provider) {
        super("Byte Viewer Options");
        this.provider = provider;
        this.addWorkPanel(this.buildPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setResizable(false);
        this.setHelpLocation(new HelpLocation("ByteViewerPlugin", "Byte_Viewer_Options"));
        this.setRememberLocation(false);
        this.setRememberSize(false);
    }

    private JComponent buildPanel() {
        JPanel mainPanel = new JPanel((LayoutManager)new VerticalLayout(10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(this.buildSettingsPanel());
        mainPanel.add(this.buildViewOptionsPanel());
        this.setOkEnabled(this.hasValidFieldValues());
        return mainPanel;
    }

    private Component buildSettingsPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new GLabel("Alignment Address:"));
        this.buildAddressField(panel);
        panel.add((Component)new GLabel("Bytes Per Line:"));
        this.bytesPerLineField = new FixedBitSizeValueField(8, false, true);
        this.bytesPerLineField.setFormat(10, false);
        this.bytesPerLineField.setMinMax(BigInteger.valueOf(1L), BigInteger.valueOf(256L));
        this.bytesPerLineField.setValue(BigInteger.valueOf(this.provider.getBytesPerLine()));
        panel.add((Component)this.bytesPerLineField);
        this.bytesPerLineField.addChangeListener((ChangeListener)this);
        this.bytesPerLineField.getAccessibleContext().setAccessibleName("Bytes Per Line");
        panel.add((Component)new GLabel("Group size (Hex View Only):"));
        this.groupSizeField = new FixedBitSizeValueField(8, false, true);
        this.groupSizeField.setFormat(10, false);
        this.groupSizeField.setMinMax(BigInteger.valueOf(1L), BigInteger.valueOf(256L));
        this.groupSizeField.setValue(BigInteger.valueOf(this.provider.getGroupSize()));
        panel.add((Component)this.groupSizeField);
        this.groupSizeField.addChangeListener((ChangeListener)this);
        this.groupSizeField.getAccessibleContext().setAccessibleName("Group Size");
        return panel;
    }

    private void buildAddressField(JPanel parentPanel) {
        ByteViewerComponentProvider byteViewerComponentProvider = this.provider;
        if (!(byteViewerComponentProvider instanceof ProgramByteViewerComponentProvider)) {
            this.buildSimpleAddressInput(parentPanel);
            return;
        }
        ProgramByteViewerComponentProvider programProvider = (ProgramByteViewerComponentProvider)byteViewerComponentProvider;
        Program program = programProvider.getProgram();
        if (program == null) {
            this.buildSimpleAddressInput(parentPanel);
            return;
        }
        Address alignment = this.getAlignmentAddress();
        if (alignment == null) {
            this.buildSimpleAddressInput(parentPanel);
            return;
        }
        this.addressInputField = new AddressInput(program, a -> this.update());
        this.addressInputField.setAccessibleName("Alignment Address");
        this.addressInputField.setAddressSpaceFilter(s -> s == alignment.getAddressSpace());
        this.addressInputField.setAddress(alignment);
        parentPanel.add((Component)this.addressInputField);
    }

    private void buildSimpleAddressInput(JPanel parentPanel) {
        this.addressInputField = new AddressInput();
        this.addressInputField.setAccessibleName("Alignment Address");
        this.addressInputField.setEnabled(false);
        parentPanel.add((Component)this.addressInputField);
    }

    private Component buildViewOptionsPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 2, 40, 0));
        TitledBorder outer = BorderFactory.createTitledBorder("Views");
        Border inner = BorderFactory.createEmptyBorder(5, 15, 5, 15);
        panel.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        Set<String> currentViews = this.provider.getCurrentViews();
        List<String> dataModelNames = this.provider.getDataFormatNames();
        for (String formatName : dataModelNames) {
            GCheckBox checkBox = new GCheckBox(formatName);
            checkBox.addActionListener((ActionListener)this);
            this.checkboxMap.put(formatName, (JCheckBox)checkBox);
            if (currentViews.contains(formatName)) {
                checkBox.setSelected(true);
            }
            panel.add((Component)checkBox);
        }
        return panel;
    }

    private Address getAlignmentAddress() {
        int bytesPerLine = this.provider.getBytesPerLine();
        int offset = this.provider.getOffset();
        Program program = ((ProgramByteViewerComponentProvider)this.provider).getProgram();
        Address minAddr = program.getMinAddress();
        if (minAddr == null) {
            return null;
        }
        long addressOffset = minAddr.getOffset() + (long)offset;
        int alignment = (int)(addressOffset % (long)bytesPerLine);
        return alignment == 0 ? minAddr : minAddr.add((long)(bytesPerLine - alignment));
    }

    protected void okCallback() {
        int bytesPerLine = this.bytesPerLineField.getValue().intValue();
        int addrOffset = 0;
        Address alignmentAddress = this.addressInputField.getAddress();
        if (alignmentAddress != null) {
            addrOffset = (int)(alignmentAddress.getOffset() % (long)bytesPerLine);
        }
        int offset = addrOffset == 0 ? 0 : bytesPerLine - addrOffset;
        int groupSize = this.groupSizeField.getValue().intValue();
        this.removeDeletedViews();
        this.provider.setBytesPerLine(256);
        this.provider.setGroupSize(groupSize);
        this.provider.setBytesPerLine(bytesPerLine);
        this.provider.setBlockOffset(offset);
        this.addNewViews();
        this.close();
    }

    private void removeDeletedViews() {
        Set<String> currentViews = this.provider.getCurrentViews();
        for (String viewName : currentViews) {
            JCheckBox checkBox = this.checkboxMap.get(viewName);
            if (checkBox.isSelected()) continue;
            this.provider.removeView(viewName, true);
        }
    }

    private void addNewViews() {
        Set<String> currentViews = this.provider.getCurrentViews();
        for (String viewName : this.checkboxMap.keySet()) {
            JCheckBox checkBox = this.checkboxMap.get(viewName);
            if (currentViews.contains(viewName) || !checkBox.isSelected()) continue;
            this.provider.addView(viewName);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update();
    }

    private void update() {
        this.setOkEnabled(this.hasValidFieldValues());
    }

    private boolean hasValidFieldValues() {
        if (!this.validateAddress()) {
            return false;
        }
        BigInteger bytesPerLine = this.bytesPerLineField.getValue();
        if (bytesPerLine == null) {
            this.setStatusText("Enter a value for Bytes Per Line");
            return false;
        }
        BigInteger groupSize = this.groupSizeField.getValue();
        if (groupSize == null) {
            this.setStatusText("Enter a group size");
            return false;
        }
        if (bytesPerLine.intValue() % groupSize.intValue() != 0) {
            this.setStatusText("The bytes per line must be a multiple of the group size.");
            return false;
        }
        if (this.checkForUnsupportedModels(bytesPerLine.intValue())) {
            this.setStatusText("Not all selected views support the current bytes per line value.");
            return false;
        }
        if (!this.atLeastOneViewOn()) {
            this.setStatusText("You must have at least one view selected");
            return false;
        }
        this.setStatusText("");
        return true;
    }

    private boolean validateAddress() {
        if (!this.addressInputField.isEnabled()) {
            return true;
        }
        String addrText = this.addressInputField.getText();
        if (StringUtils.isBlank((CharSequence)addrText)) {
            this.setStatusText("Enter an alignment address");
            return false;
        }
        Address alignmentAddress = this.addressInputField.getAddress();
        if (alignmentAddress == null) {
            this.setStatusText("Invalid alignment address:" + addrText);
            return false;
        }
        return true;
    }

    private boolean atLeastOneViewOn() {
        Set<Map.Entry<String, JCheckBox>> entrySet = this.checkboxMap.entrySet();
        for (Map.Entry<String, JCheckBox> entry : entrySet) {
            JCheckBox checkBox = entry.getValue();
            if (!checkBox.isSelected()) continue;
            return true;
        }
        return false;
    }

    private boolean checkForUnsupportedModels(int bytesPerLine) {
        boolean isBad = false;
        Set<Map.Entry<String, JCheckBox>> entrySet = this.checkboxMap.entrySet();
        for (Map.Entry<String, JCheckBox> entry : entrySet) {
            JCheckBox checkBox = entry.getValue();
            DataFormatModel model = this.provider.getDataFormatModel(entry.getKey());
            if (model.validateBytesPerLine(bytesPerLine)) {
                checkBox.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
                continue;
            }
            checkBox.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
            isBad |= checkBox.isSelected();
        }
        return isBad;
    }
}

