/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.util.bin.format.objc.objc1;

import java.io.IOException;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.*;
import ghidra.program.model.data.*;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;

public class Objc1Method extends ObjcMethod {
	private String name;
	private String signature;
	private int address;

	Objc1Method(Program program, ObjcState state, BinaryReader reader, ObjcMethodType methodType)
			throws IOException {
		super(program, state, reader, methodType);

		name = ObjcUtils.dereferenceAsciiString(reader, is32bit);
		signature = ObjcUtils.dereferenceAsciiString(reader, is32bit);
		address = reader.readNextInt();
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String getTypes() {
		return signature;
	}

	@Override
	public long getImplementation() {
		return Integer.toUnsignedLong(address);
	}

	@Override
	public DataType toDataType() throws DuplicateNameException, IOException {
		StructureDataType struct = new StructureDataType("objc_method", 0);
		struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
		struct.add(PointerDataType.getPointer(ASCII, pointerSize), "method_name", null);
		struct.add(PointerDataType.getPointer(ASCII, pointerSize), "method_types", null);
		struct.add(PointerDataType.getPointer(VOID, pointerSize), "method_imp", null);
		return struct;
	}

}
