/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.internal.EmptyLayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import generic.text.TextLayoutGraphics;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.clipboard.CodeBrowserClipboardProvider;
import ghidra.app.plugin.core.functiongraph.FGProvider;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FGClipboardProvider
extends CodeBrowserClipboardProvider {
    private FGController controller;

    FGClipboardProvider(PluginTool tool, FGController controller, FGProvider provider) {
        super(tool, (ComponentProvider)provider);
        this.controller = controller;
    }

    public boolean isValidContext(ActionContext context) {
        if (!(context instanceof ListingActionContext)) {
            return false;
        }
        return context.getComponentProvider() == this.componentProvider;
    }

    protected Transferable copyCode(TaskMonitor monitor) {
        try {
            TextLayoutGraphics g = new TextLayoutGraphics();
            Rectangle rect = new Rectangle(2048, 2048);
            AddressRangeIterator rangeItr = this.currentSelection.getAddressRanges();
            while (rangeItr.hasNext()) {
                AddressRange curRange = (AddressRange)rangeItr.next();
                Address curAddress = curRange.getMinAddress();
                Address maxAddress = curRange.getMaxAddress();
                while (!(monitor.isCancelled() || curAddress != null && curAddress.compareTo((Object)maxAddress) > 0 || (curAddress = this.copyDataForAddress(curAddress, curRange, g, rect)) == null)) {
                }
            }
            return FGClipboardProvider.createStringTransferable((String)g.getBuffer().toString());
        }
        catch (Exception e) {
            String message = "Copy failed: " + ExceptionUtils.getMessage((Throwable)e);
            Msg.error((Object)((Object)this), (Object)message, (Throwable)e);
            this.tool.setStatusInfo(message, true);
            return null;
        }
    }

    private Address copyDataForAddress(Address address, AddressRange currentRange, TextLayoutGraphics g, Rectangle rectangle) {
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph functionGraph = functionGraphData.getFunctionGraph();
        FGVertex vertex = functionGraph.getVertexForAddress(address);
        if (vertex == null) {
            return null;
        }
        ListingModel listingModel = vertex.getListingModel(address);
        Layout layout = listingModel.getLayout(address, false);
        if (layout != null) {
            EmptyLayoutBackgroundColorManager layoutColorMap = new EmptyLayoutBackgroundColorManager(PAINT_CONTEXT.getBackground());
            layout.paint(null, (Graphics)g, PAINT_CONTEXT, rectangle, (LayoutBackgroundColorManager)layoutColorMap, null);
            g.flush();
        }
        if (address.equals((Object)currentRange.getMaxAddress())) {
            return null;
        }
        Address addressAfter = listingModel.getAddressAfter(address);
        if (addressAfter != null) {
            return addressAfter;
        }
        Address nextAddress = null;
        try {
            nextAddress = address.add((long)layout.getIndexSize());
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
        return nextAddress;
    }
}

