/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.zstd;

import ghidra.file.cliwrapper.AbstractCliToolWrapper;
import ghidra.file.cliwrapper.SemVer;
import ghidra.file.cliwrapper.StreamDecompressorCliToolWrapper;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZstdCliToolWrapper
extends AbstractCliToolWrapper
implements StreamDecompressorCliToolWrapper {
    private static final SemVer MIN_VER = SemVer.parse("1.1.0");
    private static final SemVer MAX_VER_EX = SemVer.parse("2.0");
    private static final String NATIVE_EXE_NAME = "zstd";
    private static final Pattern VERSION_STR_PATTERN = Pattern.compile(".*Zstandard.*v([^,]+),.*");

    public static ZstdCliToolWrapper findTool(TaskMonitor monitor) {
        return ZstdCliToolWrapper.findToolWrapper(List.of(NATIVE_EXE_NAME), monitor, ZstdCliToolWrapper::new);
    }

    public ZstdCliToolWrapper(File nativeExecutable) {
        super(nativeExecutable);
    }

    @Override
    public boolean isValid(TaskMonitor monitor) {
        try {
            Matcher m;
            ArrayList stdoutLines = new ArrayList();
            if (this.execAndReadStdOut(List.of("--version"), monitor, stdoutLines::add) == 0 && stdoutLines.size() == 1 && (m = VERSION_STR_PATTERN.matcher((CharSequence)stdoutLines.get(0))).matches()) {
                SemVer ver = SemVer.parse(m.group(1));
                return ver != SemVer.INVALID && MIN_VER.compareTo(ver) <= 0 && MAX_VER_EX.compareTo(ver) > 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void decompressStream(InputStream is, OutputStream os, TaskMonitor monitor) throws IOException {
        monitor.initialize(0L, "Extracting");
        int exitVal = this.execAndRedirectStdOut(List.of("-dcf"), is, os, monitor);
        if (exitVal != 0) {
            throw new IOException("zstd tool error " + exitVal);
        }
    }
}

