/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.lzfse;

import ghidra.file.cliwrapper.AbstractCliToolWrapper;
import ghidra.file.cliwrapper.StreamDecompressorCliToolWrapper;
import ghidra.framework.Application;
import ghidra.framework.OperatingSystem;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class LzfseCliToolWrapper
extends AbstractCliToolWrapper
implements StreamDecompressorCliToolWrapper {
    private static final String LZFSE_NATIVE_BINARY_NAME = "lzfse";

    public static LzfseCliToolWrapper findTool(TaskMonitor monitor) {
        try {
            LzfseCliToolWrapper tmpTool;
            File lzfseNativeBinary;
            Object lzfseName = LZFSE_NATIVE_BINARY_NAME;
            if (OperatingSystem.CURRENT_OPERATING_SYSTEM.equals((Object)OperatingSystem.WINDOWS)) {
                lzfseName = (String)lzfseName + ".exe";
            }
            if ((lzfseNativeBinary = Application.getOSFile((String)lzfseName)) != null && (tmpTool = new LzfseCliToolWrapper(lzfseNativeBinary)).isValid(monitor)) {
                return tmpTool;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public LzfseCliToolWrapper(File nativeExecutable) {
        super(nativeExecutable);
    }

    @Override
    public boolean isValid(TaskMonitor monitor) {
        try {
            StringBuilder sb = new StringBuilder();
            if (this.execAndReadStdOut(List.of("-h"), monitor, sb::append) == 0) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void decompressStream(InputStream is, OutputStream os, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.initialize(0L, "Extracting");
        int exitVal = this.execAndRedirectStdOut(List.of("-decode"), is, os, monitor);
        if (exitVal != 0) {
            throw new IOException("lzfse tool error " + exitVal);
        }
    }
}

