/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.bootimg.BootImageHeader;
import ghidra.file.formats.android.bootimg.BootImageHeaderFactory;
import ghidra.file.formats.android.bootimg.BootImageUtil;
import ghidra.file.formats.android.bootimg.VendorBootImageHeader;
import ghidra.file.formats.android.bootimg.VendorBootImageHeaderFactory;
import ghidra.file.formats.android.bootimg.VendorBootImageHeaderV4;
import ghidra.file.formats.android.bootimg.VendorRamdiskTableEntryV4;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class BootImageAnalyzer
extends FileFormatAnalyzer
implements AnalysisWorker {
    private MessageLog messageLog;

    public String getName() {
        return "Android Boot, Recovery, or Vendor Image Annotation";
    }

    public boolean getDefaultEnablement(Program program) {
        return false;
    }

    public String getDescription() {
        return "Annotates Android Boot, Recovery, or Vendor Image files.";
    }

    public String getWorkerName() {
        return "BootImageAnalyzer";
    }

    public boolean canAnalyze(Program program) {
        try {
            return BootImageUtil.isBootImage(program) || BootImageUtil.isVendorBootImage(program);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isPrototype() {
        return true;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        this.messageLog = log;
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        return manager.scheduleWorker((AnalysisWorker)this, null, false, monitor);
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        if (BootImageUtil.isBootImage(program)) {
            this.markupBootImage(program, reader, monitor);
        } else if (BootImageUtil.isVendorBootImage(program)) {
            this.markupVendorBootImage(program, reader, monitor);
        }
        this.removeEmptyFragments(program);
        return true;
    }

    private void markupBootImage(Program program, BinaryReader reader, TaskMonitor monitor) throws IOException, DuplicateNameException, NotFoundException, CodeUnitInsertionException {
        Address end;
        Address start;
        BootImageHeader header;
        DataType headerDataType;
        Address address = program.getMinAddress();
        Data headerData = this.createData(program, address, headerDataType = (header = BootImageHeaderFactory.getBootImageHeader(reader)).toDataType());
        if (headerData == null) {
            this.messageLog.appendMsg("Unable to create header data.");
            return;
        }
        this.createFragment(program, headerDataType.getName(), this.toAddr(program, 0L), this.toAddr(program, header.getPageSize()));
        if (header.getKernelSize() > 0) {
            start = this.toAddr(program, header.getKernelOffset());
            end = this.toAddr(program, header.getKernelOffset() + (long)header.getKernelSize());
            this.createFragment(program, "kernel", start, end);
        }
        if (header.getRamdiskSize() > 0) {
            start = this.toAddr(program, header.getRamdiskOffset());
            end = this.toAddr(program, header.getRamdiskOffset() + header.getRamdiskSize());
            this.createFragment(program, "ramdisk", start, end);
        }
        if (header.getSecondSize() > 0) {
            start = this.toAddr(program, header.getSecondOffset());
            end = this.toAddr(program, header.getSecondOffset() + (long)header.getSecondSize());
            this.createFragment(program, "second stage", start, end);
        }
        this.changeDataSettings(program, monitor);
    }

    private void markupVendorBootImage(Program program, BinaryReader reader, TaskMonitor monitor) throws IOException, DuplicateNameException, CodeUnitInsertionException, NotFoundException, CancelledException {
        VendorBootImageHeader header;
        DataType headerDataType;
        Address address = program.getMinAddress();
        Data headerData = this.createData(program, address, headerDataType = (header = VendorBootImageHeaderFactory.getVendorBootImageHeader(reader)).toDataType());
        if (headerData == null) {
            this.messageLog.appendMsg("Unable to create header data.");
        }
        this.createFragment(program, headerDataType.getName(), this.toAddr(program, 0L), this.toAddr(program, headerData.getLength()));
        this.markupVendorRamdisk(program, header);
        if (header.getDtbSize() > 0) {
            Address start = this.toAddr(program, header.getDtbOffset());
            Address end = this.toAddr(program, header.getDtbOffset() + (long)header.getDtbSize());
            this.createFragment(program, "dtb", start, end);
        }
        this.markupVendorBootImageV4(header, program, monitor);
    }

    private void markupVendorRamdisk(Program program, VendorBootImageHeader header) throws IOException, DuplicateNameException, NotFoundException {
        if (header.getNestedVendorRamdiskCount() > 1L) {
            int i = 0;
            while ((long)i < header.getNestedVendorRamdiskCount()) {
                Address start = this.toAddr(program, header.getNestedVendorRamdiskOffset(i));
                Address end = this.toAddr(program, header.getNestedVendorRamdiskOffset(i) + (long)header.getNestedVendorRamdiskSize(i));
                this.createFragment(program, "ramdisk_" + i, start, end);
                ++i;
            }
        } else if (header.getVendorRamdiskSize() > 0) {
            Address start = this.toAddr(program, header.getVendorRamdiskOffset());
            Address end = this.toAddr(program, header.getVendorRamdiskOffset() + (long)header.getVendorRamdiskSize());
            this.createFragment(program, "ramdisk", start, end);
        }
    }

    private void markupVendorBootImageV4(VendorBootImageHeader header, Program program, TaskMonitor monitor) throws DuplicateNameException, NotFoundException, CancelledException, IOException, CodeUnitInsertionException {
        if (header instanceof VendorBootImageHeaderV4) {
            Address end;
            Address start;
            VendorBootImageHeaderV4 v4 = (VendorBootImageHeaderV4)header;
            if (v4.getVendorRamdiskTableEntrySize() > 0) {
                start = this.toAddr(program, v4.getVendorRamdiskTableOffset());
                end = this.toAddr(program, v4.getVendorRamdiskTableOffset() + (long)v4.getVendorRamdiskTableSize());
                this.createFragment(program, "Ramdisk Table", start, end);
                for (VendorRamdiskTableEntryV4 entry : v4.getVendorRamdiskTableEntryList()) {
                    monitor.checkCancelled();
                    DataType entryDataType = entry.toDataType();
                    this.createData(program, start, entryDataType);
                    start = start.add((long)entryDataType.getLength());
                }
            }
            if (v4.getBootConfigSize() > 0) {
                start = this.toAddr(program, v4.getBootConfigOffset());
                end = this.toAddr(program, v4.getBootConfigOffset() + (long)v4.getBootConfigSize());
                this.createFragment(program, "Boot Config", start, end);
            }
        }
    }
}

