/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ThreeColumnLayout
implements LayoutManager {
    private static final int DEFAULT_VGAP = 5;
    private static final int DEFAULT_HGAP = 5;
    private static final int MIN_MAIN_COMP_WIDTH = 80;
    private int vgap;
    private int[] hgaps;
    private int[] minPreferredWidths = new int[3];

    public ThreeColumnLayout() {
        this(5, new int[]{5, 5}, new int[]{0, 80, 0});
    }

    public ThreeColumnLayout(int vgap, int hgap1, int hgap2) {
        this(vgap, new int[]{hgap1, hgap2}, new int[]{0, 80, 0});
    }

    public ThreeColumnLayout(int vgap, int[] hgaps, int[] minPreferredWidths) {
        this.vgap = vgap;
        this.hgaps = hgaps;
        this.minPreferredWidths = minPreferredWidths;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension d = new Dimension(0, 0);
        Insets insets = parent.getInsets();
        int[] widths = this.getPreferredWidths(parent);
        d.width = widths[0] + this.hgaps[0] + widths[1] + this.hgaps[1] + widths[2] + insets.left + insets.right;
        int n = parent.getComponentCount();
        for (int i = 0; i < n; i += 3) {
            Component c = parent.getComponent(i);
            int height = c.getPreferredSize().height;
            if (i < n - 2) {
                c = parent.getComponent(i + 1);
                height = Math.max(c.getPreferredSize().height, height);
                c = parent.getComponent(i + 2);
                height = Math.max(c.getPreferredSize().height, height);
            }
            d.height += height;
            d.height += this.vgap;
        }
        d.height -= this.vgap;
        d.height += insets.top + insets.bottom;
        return d;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        int[] widths = this.getPreferredWidths(parent);
        Dimension d = parent.getSize();
        Insets insets = parent.getInsets();
        int width = d.width - (insets.left + insets.right);
        int x = insets.left;
        int y = insets.top;
        int width1 = widths[0];
        int width3 = widths[2];
        int width2 = Math.max(this.minPreferredWidths[1], width - (width1 + width3 + this.hgaps[0] + this.hgaps[1]));
        int compCount = parent.getComponentCount();
        for (int i = 0; i < compCount; i += 3) {
            Component c = parent.getComponent(i);
            int height = c.getPreferredSize().height;
            if (i < compCount - 2) {
                Component c2 = parent.getComponent(i + 1);
                Component c3 = parent.getComponent(i + 2);
                height = Math.max(height, c2.getPreferredSize().height);
                height = Math.max(height, c3.getPreferredSize().height);
                c2.setBounds(x + width1 + this.hgaps[0], y, width2, height);
                c3.setBounds(x + width1 + this.hgaps[0] + width2 + this.hgaps[1], y, width3, height);
            }
            c.setBounds(x, y, width1, height);
            y += height + this.vgap;
        }
    }

    int[] getPreferredWidths(Container parent) {
        int[] widths = new int[3];
        System.arraycopy(this.minPreferredWidths, 0, widths, 0, 3);
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            int colIndex = i % 3;
            widths[colIndex] = Math.max(widths[colIndex], d.width);
        }
        return widths;
    }
}

