/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.jung.JungDirectedGraph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LazyMap;

public class GraphToTreeAlgorithm<V, E extends GEdge<V>> {
    private GDirectedGraph<V, E> graph;
    private Comparator<E> edgeComparator;

    public GraphToTreeAlgorithm(GDirectedGraph<V, E> graph, Comparator<E> edgeComparator) {
        this.graph = graph;
        this.edgeComparator = edgeComparator;
    }

    public GDirectedGraph<V, E> toTree(V root) {
        List<V> sorted = this.topolocigalSort(root);
        Map<V, Depth> depthMap = this.assignDepths(root, sorted);
        return this.createTree(root, sorted, depthMap);
    }

    public List<V> topolocigalSort(V root) {
        HashSet visited = new HashSet();
        ArrayList ordered = new ArrayList();
        ArrayDeque<VertexChildIterator> stack = new ArrayDeque<VertexChildIterator>();
        stack.push(new VertexChildIterator(this, root));
        visited.add(root);
        while (!stack.isEmpty()) {
            VertexChildIterator childIterator = (VertexChildIterator)stack.getFirst();
            if (childIterator.hasNext()) {
                Object child = childIterator.next();
                if (visited.contains(child)) continue;
                stack.push(new VertexChildIterator(this, child));
                visited.add(child);
                continue;
            }
            ordered.add(childIterator.getParent());
            stack.pop();
        }
        Collections.reverse(ordered);
        return ordered;
    }

    private JungDirectedGraph<V, E> createTree(V root, List<V> sorted, Map<V, Depth> depthMap) {
        HashSet visited = new HashSet();
        visited.add(root);
        JungDirectedGraph tree = new JungDirectedGraph();
        for (V v : sorted) {
            tree.addVertex(v);
        }
        for (V parent : sorted) {
            Depth parentDepth = depthMap.get(parent);
            Collection<E> outEdges = this.graph.getOutEdges(parent);
            for (GEdge e : outEdges) {
                Depth childDepth;
                Object child = e.getEnd();
                if (visited.contains(child) || !(childDepth = depthMap.get(child)).isDirectChildOf(parentDepth)) continue;
                tree.addEdge(e);
                visited.add(child);
            }
        }
        return tree;
    }

    private Map<V, Depth> assignDepths(V root, List<V> sorted) {
        HashSet<V> visited = new HashSet<V>();
        LazyMap depthMap = LazyMap.lazyMap(new HashMap(), k -> new Depth());
        depthMap.put(root, new Depth());
        for (V parent : sorted) {
            visited.add(parent);
            Depth parentDepth = (Depth)depthMap.get(parent);
            ArrayList<E> edges = new ArrayList<E>();
            Collection<E> out = this.graph.getOutEdges(parent);
            if (out != null) {
                edges.addAll(out);
            }
            edges.sort(this.edgeComparator);
            for (GEdge e : edges) {
                Object child = e.getEnd();
                if (visited.contains(child)) continue;
                Depth childDepth = (Depth)depthMap.get(child);
                childDepth.adjustDepth(parentDepth);
            }
        }
        return depthMap;
    }

    private class VertexChildIterator {
        private V parent;
        private Iterator<E> it;

        VertexChildIterator(GraphToTreeAlgorithm graphToTreeAlgorithm, V parent) {
            this.parent = parent;
            Collection out = graphToTreeAlgorithm.graph.getOutEdges(parent);
            ArrayList outEdges = new ArrayList();
            if (out != null) {
                outEdges.addAll(out);
            }
            outEdges.sort(graphToTreeAlgorithm.edgeComparator);
            this.it = outEdges.reversed().iterator();
        }

        V getParent() {
            return this.parent;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public V next() {
            return ((GEdge)this.it.next()).getEnd();
        }
    }

    private static class Depth {
        private int depth = 0;

        private Depth() {
        }

        private void adjustDepth(Depth parentDepth) {
            this.depth = Math.max(this.depth, parentDepth.depth + 1);
        }

        private boolean isDirectChildOf(Depth parentDepth) {
            return this.depth == parentDepth.depth + 1;
        }
    }
}

