/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.taint;

import ghidra.pcode.emu.DefaultPcodeThread;
import ghidra.pcode.exec.AnnotatedPcodeUseropLibrary;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.taint.model.TaintMark;
import ghidra.taint.model.TaintSet;
import ghidra.taint.model.TaintVec;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class TaintPcodeUseropLibrary
extends AnnotatedPcodeUseropLibrary<Pair<byte[], TaintVec>> {
    private long nextVarId;
    private long nextArrId;

    protected TaintSet nextVar() {
        TaintMark mark = new TaintMark("var_" + this.nextVarId++, Set.of());
        return TaintSet.of(mark);
    }

    protected String nextArrName() {
        return "arr_" + this.nextArrId++;
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop
    public Pair<byte[], TaintVec> taint_var(Pair<byte[], TaintVec> in, @AnnotatedPcodeUseropLibrary.OpOp PcodeOp op, @AnnotatedPcodeUseropLibrary.OpExecutor PcodeExecutor executor) {
        if (executor instanceof DefaultPcodeThread.PcodeThreadExecutor) {
            DefaultPcodeThread.PcodeThreadExecutor te = (DefaultPcodeThread.PcodeThreadExecutor)executor;
            Address counter = te.getThread().getCounter();
            op = new PcodeOp(counter, op.getSeqnum().getTime(), op.getOpcode(), op.getInputs(), op.getOutput());
        }
        return Pair.of((Object)((byte[])in.getLeft()), (Object)((TaintVec)in.getRight()).eachUnion(this.nextVar()).withOp(op));
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop
    public Pair<byte[], TaintVec> taint_arr(Pair<byte[], TaintVec> in, @AnnotatedPcodeUseropLibrary.OpOp PcodeOp op, @AnnotatedPcodeUseropLibrary.OpExecutor PcodeExecutor executor) {
        if (executor instanceof DefaultPcodeThread.PcodeThreadExecutor) {
            DefaultPcodeThread.PcodeThreadExecutor te = (DefaultPcodeThread.PcodeThreadExecutor)executor;
            Address counter = te.getThread().getCounter();
            op = new PcodeOp(counter, op.getSeqnum().getTime(), op.getOpcode(), op.getInputs(), op.getOutput());
        }
        TaintVec taint = (TaintVec)in.getRight();
        taint = taint.zipUnion(TaintVec.array(this.nextArrName(), 0L, taint.length)).withOp(op);
        return Pair.of((Object)((byte[])in.getLeft()), (Object)taint);
    }
}

