/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.platform;

import ghidra.app.plugin.core.debug.event.DebuggerPlatformPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOpinion;
import ghidra.app.services.DebuggerPlatformService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.target.TraceObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

@PluginInfo(shortDescription="Debugger platform service plugin", description="Selects and manages platforms for the current focus", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class}, servicesProvided={DebuggerPlatformService.class})
public class DebuggerPlatformServicePlugin
extends Plugin
implements DebuggerPlatformService {
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    private final Map<Trace, DebuggerPlatformMapper> mappersByTrace = new HashMap<Trace, DebuggerPlatformMapper>();

    public DebuggerPlatformServicePlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerPlatformMapper getCurrentMapperFor(Trace trace) {
        Map<Trace, DebuggerPlatformMapper> map = this.mappersByTrace;
        synchronized (map) {
            return this.mappersByTrace.get(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerPlatformMapper getMapper(Trace trace, TraceObject object, long snap) {
        DebuggerPlatformMapper mapper;
        Map<Trace, DebuggerPlatformMapper> map = this.mappersByTrace;
        synchronized (map) {
            mapper = this.mappersByTrace.get(trace);
            if (mapper != null && mapper.canInterpret(object, snap)) {
                return mapper;
            }
            mapper = this.getNewMapper(trace, object, snap);
            if (mapper == null) {
                return null;
            }
            this.mappersByTrace.put(trace, mapper);
        }
        this.firePluginEvent(new DebuggerPlatformPluginEvent(this.getName(), trace, mapper));
        return mapper;
    }

    public DebuggerPlatformMapper getNewMapper(Trace trace, TraceObject object, long snap) {
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            throw new IllegalArgumentException("Trace is not opened in this tool");
        }
        Iterator<DebuggerPlatformOffer> iterator = DebuggerPlatformOpinion.queryOpinions(trace, object, snap, false).iterator();
        if (iterator.hasNext()) {
            DebuggerPlatformOffer offer = iterator.next();
            return offer.take(this.tool, trace);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentMapperFor(Trace trace, TraceObject focus, DebuggerPlatformMapper mapper, long snap) {
        Objects.requireNonNull(trace);
        Objects.requireNonNull(mapper);
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            throw new IllegalArgumentException("Trace is not opened in this tool");
        }
        Map<Trace, DebuggerPlatformMapper> map = this.mappersByTrace;
        synchronized (map) {
            this.mappersByTrace.put(trace, mapper);
        }
        TracePlatform platform = mapper.addToTrace(focus, snap);
        this.firePluginEvent(new DebuggerPlatformPluginEvent(this.getName(), trace, mapper));
        if (this.traceManager.getCurrentTrace() == trace) {
            this.traceManager.activatePlatform(platform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent ev = (TraceClosedPluginEvent)event;
            Map<Trace, DebuggerPlatformMapper> map = this.mappersByTrace;
            synchronized (map) {
                this.mappersByTrace.remove(ev.getTrace());
            }
        }
    }
}

