/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.timeoverview;

import docking.action.DockingActionIf;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.debug.gui.timeoverview.TimeOverviewColorPlugin;
import ghidra.app.plugin.core.debug.gui.timeoverview.TimeOverviewColorService;
import ghidra.app.util.viewer.listingpanel.ListingOverviewProvider;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Lifespan;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class TimeOverviewColorComponent
extends JPanel
implements ListingOverviewProvider {
    private static final Color DEFAULT_COLOR = Color.GRAY;
    protected TimeOverviewColorService service;
    private Color[] colorsByPixel = new Color[0];
    private final SwingUpdateManager refreshUpdater = new SwingUpdateManager(100, 15000, () -> this.doRefresh());
    private PluginTool tool;
    private List<DockingActionIf> actions;
    private TimeOverviewColorPlugin plugin;

    public TimeOverviewColorComponent(PluginTool tool, TimeOverviewColorService overviewColorService) {
        this.tool = tool;
        this.service = overviewColorService;
        overviewColorService.setOverviewComponent(this);
        this.addMouseListener(new MouseAdapter(){
            private int pressedY;
            private boolean enableDrag = false;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    Long snap = TimeOverviewColorComponent.this.service.getSnap(e.getY());
                    TimeOverviewColorComponent.this.gotoSnap(snap);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.enableDrag = true;
                this.pressedY = e.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.enableDrag) {
                    Lifespan span;
                    Long start = TimeOverviewColorComponent.this.service.getSnap(this.pressedY);
                    Long stop = TimeOverviewColorComponent.this.service.getSnap(e.getY());
                    if (start == null || stop == null) {
                        return;
                    }
                    if ((e.getModifiersEx() & 0x40) != 0) {
                        Lifespan prev = TimeOverviewColorComponent.this.getLifespan();
                        if (prev != null) {
                            int shift = stop.intValue() - start.intValue();
                            span = Lifespan.span((long)(prev.lmin() - (long)shift), (long)(prev.lmax() - (long)shift));
                        } else {
                            span = prev;
                        }
                    } else {
                        if (start > stop) {
                            Long tmp = stop;
                            stop = start;
                            start = tmp;
                        }
                        span = Lifespan.span((long)start, (long)stop);
                    }
                    TimeOverviewColorComponent.this.plugin.setLifespan(span);
                    this.enableDrag = false;
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
        this.actions = this.service.getActions();
    }

    public void dispose() {
        this.uninstallActions();
    }

    public void installActions() {
        if (this.actions == null) {
            return;
        }
        for (DockingActionIf action : this.actions) {
            this.tool.addAction(action);
        }
    }

    public void uninstallActions() {
        if (this.actions == null) {
            return;
        }
        for (DockingActionIf action : this.actions) {
            this.tool.removeAction(action);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(16, 1);
    }

    protected void gotoSnap(Long snap) {
        this.plugin.gotoSnap(snap);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Long snap = this.service.getSnap(e.getY());
        return this.service.getToolTipText(snap);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int pixelCount = this.getOverviewPixelCount();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width - 1, this.getHeight() - 1);
        if (this.service.getTrace() == null) {
            return;
        }
        for (int i = 0; i < pixelCount; ++i) {
            Color color = this.getColor(i);
            g.setColor(color);
            g.fillRect(1, i, width - 3, 1);
        }
        if (this.colorsByPixel.length != pixelCount) {
            this.colorsByPixel = new Color[pixelCount];
            this.refreshUpdater.updateLater();
        }
    }

    private Color getColor(int index) {
        if (this.colorsByPixel != null && index < this.colorsByPixel.length) {
            return this.colorsByPixel[index];
        }
        return DEFAULT_COLOR;
    }

    public int getOverviewPixelCount() {
        return Math.max(this.getHeight(), 0);
    }

    private void doRefresh() {
        for (int i = 0; i < this.colorsByPixel.length; ++i) {
            if (this.colorsByPixel[i] != null) continue;
            Long snap = this.service.getSnap(i);
            this.colorsByPixel[i] = this.service.getColor(snap);
        }
        this.repaint();
    }

    public JComponent getComponent() {
        return this;
    }

    public void setLifeSet(TreeSet<Long> set) {
        this.service.setIndices(set);
        this.colorsByPixel = new Color[this.getOverviewPixelCount()];
        this.refreshUpdater.updateLater();
    }

    public void refreshAll() {
        this.colorsByPixel = new Color[this.getOverviewPixelCount()];
        this.refreshUpdater.updateLater();
    }

    public PluginTool getTool() {
        return this.tool;
    }

    public void setPlugin(TimeOverviewColorPlugin plugin) {
        this.plugin = plugin;
        this.service.setPlugin(plugin);
    }

    public Lifespan getLifespan() {
        return this.service.getBounds();
    }

    public void setLifespan(Lifespan bounds) {
        this.service.setBounds(bounds);
    }

    public void screenDataChanged(Program program, AddressIndexMap map) {
    }

    public void setNavigatable(Navigatable navigatable) {
    }
}

