/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import generic.Span;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.path.PathPattern;
import ghidra.trace.model.target.schema.PrimitiveTraceObjectSchema;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModelQuery {
    public static final ModelQuery EMPTY = new ModelQuery(PathFilter.NONE);
    private final PathFilter filter;

    public static ModelQuery parse(String queryString) {
        return new ModelQuery((PathFilter)PathFilter.parse((String)queryString));
    }

    public static ModelQuery elementsOf(KeyPath path) {
        return new ModelQuery((PathFilter)new PathPattern(path.index("")));
    }

    public static ModelQuery attributesOf(KeyPath path) {
        return new ModelQuery((PathFilter)new PathPattern(path.key("")));
    }

    public ModelQuery(PathFilter filter) {
        this.filter = filter;
    }

    public String toString() {
        return "<ModelQuery: " + this.filter.toString() + ">";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModelQuery)) {
            return false;
        }
        ModelQuery that = (ModelQuery)obj;
        return Objects.equals(this.filter, that.filter);
    }

    public String toQueryString() {
        return this.filter.getSingletonPattern().toPatternString();
    }

    public Stream<TraceObject> streamObjects(Trace trace, Lifespan span) {
        TraceObjectManager objects = trace.getObjectManager();
        TraceObject root = objects.getRootObject();
        return objects.getValuePaths(span, this.filter).map(p -> p.getDestinationValue((Object)root)).filter(v -> v instanceof TraceObject).map(v -> (TraceObject)v);
    }

    public Stream<TraceObjectValue> streamValues(Trace trace, Lifespan span) {
        TraceObjectManager objects = trace.getObjectManager();
        return objects.getValuePaths(span, this.filter).map(p -> {
            TraceObjectValue last = p.getLastEntry();
            return last == null ? objects.getRootObject().getCanonicalParent(0L) : last;
        });
    }

    public Stream<TraceObjectValPath> streamPaths(Trace trace, Lifespan span) {
        return trace.getObjectManager().getValuePaths(span, this.filter).map(p -> p);
    }

    public List<TraceObjectSchema> computeSchemas(Trace trace) {
        TraceObjectSchema rootSchema = trace.getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return List.of();
        }
        return this.filter.getPatterns().stream().map(p -> rootSchema.getSuccessorSchema(p.asPath())).distinct().collect(Collectors.toList());
    }

    public TraceObjectSchema computeSingleSchema(Trace trace) {
        List<TraceObjectSchema> schemas = this.computeSchemas(trace);
        if (schemas.size() != 1) {
            return PrimitiveTraceObjectSchema.OBJECT;
        }
        return schemas.get(0);
    }

    public Stream<TraceObjectSchema.AttributeSchema> computeAttributes(Trace trace) {
        TraceObjectSchema schema = this.computeSingleSchema(trace);
        return schema.getAttributeSchemas().entrySet().stream().filter(ent -> {
            String attrName = ((TraceObjectSchema.AttributeSchema)ent.getValue()).getName();
            return !"".equals(attrName) && ((String)ent.getKey()).equals(attrName);
        }).map(e -> (TraceObjectSchema.AttributeSchema)e.getValue());
    }

    protected static boolean includes(Lifespan span, PathPattern pattern, TraceObjectValue value) {
        KeyPath asPath = pattern.asPath();
        if (asPath.isRoot()) {
            return value.getParent() == null;
        }
        if (!PathFilter.keyMatches((String)asPath.key(), (String)value.getEntryKey())) {
            return false;
        }
        TraceObject parent = value.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getAncestors(span, (PathFilter)pattern.removeRight(1)).anyMatch(v -> v.getSource(parent).isRoot());
    }

    public boolean includes(Lifespan span, TraceObjectValue value) {
        if (!span.intersects((Span)value.getLifespan())) {
            return false;
        }
        for (PathPattern pattern : this.filter.getPatterns()) {
            if (!ModelQuery.includes(span, pattern, value)) continue;
            return true;
        }
        return false;
    }

    protected static boolean involves(Lifespan span, PathPattern pattern, TraceObjectValue value) {
        TraceObject parent = value.getParent();
        if (parent == null) {
            return true;
        }
        KeyPath asPath = pattern.asPath();
        while (!asPath.isRoot()) {
            if (!PathFilter.keyMatches((String)asPath.key(), (String)value.getEntryKey())) {
                asPath = asPath.parent();
                continue;
            }
            if (!parent.getAncestors(span, (PathFilter)new PathPattern(asPath = asPath.parent())).anyMatch(v -> v.getSource(parent).isRoot())) continue;
            return true;
        }
        return false;
    }

    public boolean involves(Lifespan span, TraceObjectValue value) {
        if (!span.intersects((Span)value.getLifespan())) {
            return false;
        }
        for (PathPattern pattern : this.filter.getPatterns()) {
            if (!ModelQuery.involves(span, pattern, value)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.filter.isNone();
    }
}

