/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.actions.PopupActionProvider;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.debug.disassemble.CurrentPlatformTraceDisassembleAction;
import ghidra.app.plugin.core.debug.disassemble.CurrentPlatformTracePatchInstructionAction;
import ghidra.app.plugin.core.debug.disassemble.FixedPlatformTraceDisassembleAction;
import ghidra.app.plugin.core.debug.disassemble.FixedPlatformTracePatchInstructionAction;
import ghidra.app.plugin.core.debug.disassemble.TracePatchDataAction;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerListingActionContext;
import ghidra.app.services.DebuggerPlatformService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.SleighLanguageDescription;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.ProgramContextImpl;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.guest.TraceGuestPlatform;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.UnionAddressSetView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@PluginInfo(shortDescription="Disassemble trace bytes in the debugger", description="Provides 'Disassemble as' actions for traces.", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={}, eventsProduced={}, servicesRequired={DebuggerTraceManagerService.class, DebuggerPlatformService.class}, servicesProvided={})
public class DebuggerDisassemblerPlugin
extends Plugin
implements PopupActionProvider {
    CurrentPlatformTraceDisassembleAction actionDisassemble;
    CurrentPlatformTracePatchInstructionAction actionPatchInstruction;
    TracePatchDataAction actionPatchData;

    public static RegisterValue deriveAlternativeDefaultContext(Language language, LanguageID alternative, Address address) {
        Language altLang;
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        try {
            altLang = langServ.getLanguage(alternative);
        }
        catch (LanguageNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        ProgramContextImpl ctx = new ProgramContextImpl(altLang);
        altLang.applyContextSettings((DefaultProgramContext)ctx);
        Address altAddress = altLang.getAddressFactory().getAddressSpace(address.getAddressSpace().getPhysicalSpace().getName()).getAddress(address.getOffset());
        RegisterValue altVal = ctx.getDisassemblyContext(altAddress).getBaseRegisterValue();
        RegisterValue result = new RegisterValue(language.getContextBaseRegister(), altVal.toBytes());
        return result;
    }

    public static Long isKnownRWOrEverKnownRO(Address start, Trace trace, long snap) {
        TraceMemoryManager memoryManager = trace.getMemoryManager();
        Map.Entry kent = memoryManager.getViewState(snap, start);
        if (kent != null && kent.getValue() == TraceMemoryState.KNOWN) {
            return (Long)kent.getKey();
        }
        Map.Entry mrent = memoryManager.getViewMostRecentStateEntry(snap, start);
        if (mrent == null || mrent.getValue() != TraceMemoryState.KNOWN) {
            return null;
        }
        long ks = ((TraceAddressSnapRange)mrent.getKey()).getY1();
        TraceMemoryRegion region = memoryManager.getRegionContaining(ks, start);
        if (region == null || region.isWrite(ks)) {
            return null;
        }
        return ks;
    }

    public static AddressSetView computeAutoDisassembleAddresses(Address start, Trace trace, long snap) {
        Long ks = DebuggerDisassemblerPlugin.isKnownRWOrEverKnownRO(start, trace, snap);
        if (ks == null) {
            return null;
        }
        TraceMemoryManager memoryManager = trace.getMemoryManager();
        AddressSetView readOnly = memoryManager.getRegionsAddressSetWith(ks.longValue(), r -> !r.isWrite(ks.longValue()));
        AddressSetView everKnown = memoryManager.getAddressesWithState(Lifespan.since((long)ks), s -> s == TraceMemoryState.KNOWN);
        IntersectionAddressSetView roEverKnown = new IntersectionAddressSetView(readOnly, everKnown);
        AddressSetView known = memoryManager.getAddressesWithState(ks.longValue(), s -> s == TraceMemoryState.KNOWN);
        UnionAddressSetView disassemblable = new UnionAddressSetView(new AddressSetView[]{known, roEverKnown});
        return disassemblable;
    }

    public DebuggerDisassemblerPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.tool.addPopupActionProvider((PopupActionProvider)this);
        this.createActions();
    }

    protected void createActions() {
        this.actionDisassemble = new CurrentPlatformTraceDisassembleAction(this);
        this.actionPatchInstruction = new CurrentPlatformTracePatchInstructionAction(this);
        this.actionPatchData = new TracePatchDataAction(this);
        this.tool.addAction((DockingActionIf)this.actionDisassemble);
        this.tool.addAction((DockingActionIf)this.actionPatchInstruction);
        this.tool.addAction((DockingActionIf)this.actionPatchData);
    }

    protected Collection<LanguageID> getAlternativeLanguageIDs(Language language) {
        LanguageDescription desc = language.getLanguageDescription();
        if (!(desc instanceof SleighLanguageDescription)) {
            return List.of();
        }
        SleighLanguageDescription sld = (SleighLanguageDescription)desc;
        ResourceFile slaFile = sld.getSlaFile();
        ArrayList<LanguageID> result = new ArrayList<LanguageID>();
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        for (LanguageDescription altDesc : langServ.getLanguageDescriptions(false)) {
            SleighLanguageDescription altSld;
            if (!(altDesc instanceof SleighLanguageDescription) || !(altSld = (SleighLanguageDescription)altDesc).getSlaFile().equals((Object)slaFile) || altSld.getEndian() != sld.getEndian()) continue;
            result.add(altSld.getLanguageID());
        }
        return result;
    }

    protected void getActionsForLanguage(List<DockingActionIf> result, TracePlatform platform) {
        for (LanguageID langID : this.getAlternativeLanguageIDs(platform.getLanguage())) {
            result.add((DockingActionIf)new FixedPlatformTraceDisassembleAction(this, langID, platform));
            result.add((DockingActionIf)new FixedPlatformTracePatchInstructionAction(this, langID, platform));
        }
    }

    protected void getActionsForHost(List<DockingActionIf> result, Trace trace) {
        Language language = trace.getBaseLanguage();
        if (language.getProcessor() == Processor.toProcessor((String)"DATA")) {
            return;
        }
        this.getActionsForLanguage(result, trace.getPlatformManager().getHostPlatform());
    }

    protected void getActionsForGuest(List<DockingActionIf> result, TraceGuestPlatform guest, Address hostAddress) {
        if (!guest.getHostAddressSet().contains(hostAddress)) {
            return;
        }
        this.getActionsForLanguage(result, (TracePlatform)guest);
    }

    protected void getActionsForAllGuests(List<DockingActionIf> result, Trace trace, Address address) {
        for (TraceGuestPlatform guest : trace.getPlatformManager().getGuestPlatforms()) {
            this.getActionsForGuest(result, guest, address);
        }
    }

    protected List<DockingActionIf> getActionsFor(List<DockingActionIf> result, Trace trace, long snap, Address address) {
        this.getActionsForHost(result, trace);
        this.getActionsForAllGuests(result, trace, address);
        return result;
    }

    public List<DockingActionIf> getPopupActions(Tool tool, ActionContext context) {
        if (!(context instanceof DebuggerListingActionContext)) {
            return null;
        }
        DebuggerListingActionContext lac = (DebuggerListingActionContext)context;
        Address address = lac.getAddress();
        if (address == null) {
            return null;
        }
        TraceProgramView view = lac.getProgram();
        return this.getActionsFor(new ArrayList<DockingActionIf>(), view.getTrace(), view.getSnap(), address);
    }
}

