/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.DBBuffer;
import java.io.IOException;
import java.io.OutputStream;

public class DBBufferOutputStream
extends OutputStream {
    protected final DBBuffer buffer;
    protected final int increment;
    protected int offset;

    public DBBufferOutputStream(DBBuffer buffer) {
        this(buffer, 1024);
    }

    public DBBufferOutputStream(DBBuffer buffer, int increment) {
        this.buffer = buffer;
        this.increment = increment;
        this.offset = 0;
    }

    void checkExpand(int add) throws IOException {
        int len = this.offset + add;
        if (this.buffer.length() < len) {
            this.buffer.setSize(this.buffer.length() + this.increment, true);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkExpand(b.length);
        this.buffer.put(this.offset, b);
        this.offset += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkExpand(len);
        this.buffer.put(this.offset, b, off, len);
        this.offset += len;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkExpand(1);
        this.buffer.putByte(this.offset, (byte)b);
        ++this.offset;
    }

    @Override
    public void close() throws IOException {
        this.buffer.setSize(this.offset, true);
    }
}

