/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ComponentProvider;
import docking.DockingUtils;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.services.FileSystemBrowserService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.LocalFileSystem;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.main.ApplicationLevelPlugin;
import ghidra.framework.main.FrontEndService;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.ProjectIndexService;
import ghidra.plugins.fsbrowser.FSBComponentProvider;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import utilities.util.FileUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Browse Filesystems in containers", description="This plugin allows users to browse and use the contents of containers (zips, tars, filesystems, etc)", servicesProvided={FileSystemBrowserService.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class FileSystemBrowserPlugin
extends Plugin
implements ApplicationLevelPlugin,
ProjectListener,
FileSystemBrowserService {
    private static final String LAST_FS_DIR = "LastFileSystemDirectory";
    DockingAction openFilesystemAction;
    DockingAction showFileSystemImplsAction;
    private GhidraFileChooser chooserOpen;
    private FrontEndService frontEndService;
    private Map<FSRL, FSBComponentProvider> currentBrowsers = new HashMap<FSRL, FSBComponentProvider>();
    private FileSystemService fsService;
    private File lastExportDirectory;

    public FileSystemBrowserPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.frontEndService = (FrontEndService)this.tool.getService(FrontEndService.class);
        if (this.frontEndService != null) {
            this.frontEndService.addProjectListener((ProjectListener)this);
        }
        this.setupActions();
    }

    private void setupActions() {
        this.openFilesystemAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Open File System", this.getName()).description(this.getPluginDescription().getDescription())).enabledWhen(ac -> this.tool.getProject() != null)).menuPath(new String[]{"&File", "Open File System..."})).menuGroup("Import", "z")).keyBinding(KeyStroke.getKeyStroke(73, DockingUtils.CONTROL_KEY_MODIFIER_MASK))).onAction(ac -> this.doOpenFileSystem())).buildAndInstall((Tool)this.tool);
    }

    protected void dispose() {
        super.dispose();
        if (this.openFilesystemAction != null) {
            this.openFilesystemAction.dispose();
        }
        if (this.frontEndService != null) {
            this.frontEndService.removeProjectListener((ProjectListener)this);
            this.frontEndService = null;
        }
        if (this.chooserOpen != null) {
            this.chooserOpen.dispose();
        }
        for (FSBComponentProvider provider : this.currentBrowsers.values()) {
            provider.dispose();
        }
        this.currentBrowsers.clear();
    }

    @Override
    public void openFileSystem(FSRL fsrl) {
        TaskLauncher.launchModal((String)"Open File System", monitor -> this.doOpenFilesystem(fsrl, this.tool.getActiveWindow(), monitor));
    }

    public void createNewFileSystemBrowser(FileSystemRef fsRef, GFile rootDir, boolean show) {
        if (rootDir == null) {
            rootDir = fsRef.getFilesystem().getRootDir();
        }
        RefdFile refdRootDir = new RefdFile(fsRef, rootDir);
        Swing.runIfSwingOrRunLater(() -> this.doCreateNewFileSystemBrowser(refdRootDir, show));
    }

    private void doCreateNewFileSystemBrowser(RefdFile rootFile, boolean show) {
        FSRL rootFSRL = rootFile.file.getFSRL();
        FSBComponentProvider provider = this.currentBrowsers.get(rootFSRL);
        if (provider != null) {
            Msg.info((Object)this, (Object)("Filesystem browser already open for " + String.valueOf(rootFSRL)));
            FSUtilities.uncheckedClose(rootFile, null);
        } else {
            provider = new FSBComponentProvider(this, rootFile);
            this.currentBrowsers.put(rootFSRL, provider);
            this.getTool().addComponentProvider((ComponentProvider)provider, false);
            provider.afterAddedToTool();
            provider.contextChanged();
        }
        if (show) {
            this.showProvider(provider);
        }
    }

    public void showProvider(FSBComponentProvider provider) {
        if (provider != null) {
            this.getTool().showComponentProvider((ComponentProvider)provider, true);
            this.getTool().toFront((ComponentProvider)provider);
            provider.contextChanged();
        }
    }

    void removeFileSystemBrowserComponent(FSBComponentProvider componentProvider) {
        if (componentProvider != null) {
            Swing.runIfSwingOrRunLater(() -> this.currentBrowsers.remove(componentProvider.getFSRL()));
        }
    }

    private void removeAllFileSystemBrowsers() {
        Swing.runIfSwingOrRunLater(() -> {
            for (FSBComponentProvider fsbcp : new ArrayList<FSBComponentProvider>(this.currentBrowsers.values())) {
                fsbcp.dispose();
            }
            this.currentBrowsers.clear();
        });
    }

    private void openChooser(String title, String buttonText, boolean multiSelect) {
        if (this.chooserOpen == null) {
            this.chooserOpen = new GhidraFileChooser((Component)this.tool.getActiveWindow());
            this.chooserOpen.addFileFilter(ImporterUtilities.LOADABLE_FILES_FILTER);
            this.chooserOpen.addFileFilter(ImporterUtilities.CONTAINER_FILES_FILTER);
            this.chooserOpen.setSelectedFileFilter(GhidraFileFilter.ALL);
        }
        this.chooserOpen.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        this.chooserOpen.setMultiSelectionEnabled(multiSelect);
        this.chooserOpen.setTitle(title);
        this.chooserOpen.setApproveButtonText(buttonText);
        this.chooserOpen.setLastDirectoryPreference(LAST_FS_DIR);
    }

    public void openFileSystem() {
        Swing.runLater(this::doOpenFileSystem);
    }

    private void doOpenFileSystem() {
        Window parent = this.getTool().getActiveWindow();
        this.openChooser("Select Filesystem Container To Open", "Open", false);
        this.chooserOpen.setFileSelectionMode(GhidraFileChooserMode.FILES_AND_DIRECTORIES);
        File file = this.chooserOpen.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            Msg.showInfo((Object)this, (Component)parent, (String)"Open File System Failed", (Object)("The specified file does not exist: " + file.getPath()));
            return;
        }
        if (FileUtilities.isEmpty((File)file)) {
            Msg.showInfo((Object)this, (Component)parent, (String)"Empty file", (Object)"The selected file is 0 bytes long, skipping.");
            return;
        }
        LocalFileSystem localFS = this.fsService().getLocalFS();
        if (file.isDirectory()) {
            this.createNewFileSystemBrowser(localFS.getRefManager().create(), localFS.getGFile(file), true);
            return;
        }
        TaskLauncher.launchModal((String)"Open File System", monitor -> {
            FSRL containerFSRL = localFS.getLocalFSRL(file);
            this.doOpenFilesystem(containerFSRL, parent, monitor);
        });
    }

    private void doOpenFilesystem(FSRL containerFSRL, Component parent, TaskMonitor monitor) {
        try {
            monitor.setMessage("Probing " + containerFSRL.getName() + " for filesystems");
            FileSystemRef ref = this.fsService().probeFileForFilesystem(containerFSRL, monitor, FileSystemProbeConflictResolver.GUI_PICKER);
            if (ref == null) {
                Msg.showWarn((Object)this, (Component)parent, (String)"Open Filesystem", (Object)("No filesystem provider for " + containerFSRL.getName()));
                return;
            }
            this.createNewFileSystemBrowser(ref, null, true);
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException(this, parent, "Open Filesystem Error", "Error opening filesystem for " + containerFSRL.getName(), e);
        }
    }

    private FileSystemService fsService() {
        if (this.fsService == null) {
            this.fsService = FileSystemService.getInstance();
        }
        return this.fsService;
    }

    public FSBComponentProvider getProviderFor(FSRL fsrl) {
        FSBComponentProvider provider = this.currentBrowsers.get(fsrl);
        if (provider == null) {
            Msg.info((Object)this, (Object)("Could not find browser for " + String.valueOf(fsrl)));
            return null;
        }
        return provider;
    }

    public List<FSRL> getCurrentlyOpenBrowsers() {
        return List.copyOf(this.currentBrowsers.keySet());
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
    }

    public void projectClosed(Project project) {
        this.removeAllFileSystemBrowsers();
        if (FileSystemService.isInitialized()) {
            this.fsService().closeUnusedFileSystems();
        }
        ProjectIndexService.projectClosed(project);
    }

    public void projectOpened(Project project) {
    }

    public File getLastExportDirectory() {
        return this.lastExportDirectory != null ? this.lastExportDirectory : new File(System.getProperty("user.home"));
    }

    public void setLastExportDirectory(File lastExportDirectory) {
        this.lastExportDirectory = lastExportDirectory;
    }
}

