/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.fileinfo;

import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import java.util.Objects;

public class FileAttribute<T> {
    private final FileAttributeType attributeType;
    private final String attributeDisplayName;
    private final T attributeValue;

    public static <T> FileAttribute<T> create(String name, T attributeValue) {
        return FileAttribute.create(FileAttributeType.UNKNOWN_ATTRIBUTE, name, attributeValue);
    }

    public static <T> FileAttribute<T> create(FileAttributeType attributeType, T attributeValue) {
        return FileAttribute.create(attributeType, attributeType.getDisplayName(), attributeValue);
    }

    public static <T> FileAttribute<T> create(FileAttributeType attributeType, String attributeDisplayName, T attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (!attributeType.getValueType().isInstance(attributeValue)) {
            throw new IllegalArgumentException("FileAttribute type %s does not match value: %s".formatted(new Object[]{attributeType, attributeValue.getClass()}));
        }
        return new FileAttribute<T>(attributeType, attributeDisplayName, attributeValue);
    }

    private FileAttribute(FileAttributeType attributeType, String attributeDisplayName, T attributeValue) {
        this.attributeType = attributeType;
        this.attributeDisplayName = attributeDisplayName;
        this.attributeValue = attributeValue;
    }

    public FileAttributeType getAttributeType() {
        return this.attributeType;
    }

    public String getAttributeDisplayName() {
        return this.attributeDisplayName;
    }

    public T getAttributeValue() {
        return this.attributeValue;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributeDisplayName, this.attributeType, this.attributeValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileAttribute other = (FileAttribute)obj;
        return Objects.equals(this.attributeDisplayName, other.attributeDisplayName) && this.attributeType == other.attributeType && Objects.equals(this.attributeValue, other.attributeValue);
    }
}

