/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingContextListener;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.util.GGlassPaneMessage;
import docking.widgets.OptionDialogBuilder;
import docking.widgets.table.actions.DeleteTableRowAction;
import generic.theme.GIcon;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.features.base.memsearch.bytesource.SearchRegion;
import ghidra.features.base.memsearch.combiner.Combiner;
import ghidra.features.base.memsearch.gui.MemoryMatchHighlighter;
import ghidra.features.base.memsearch.gui.MemoryScanControlPanel;
import ghidra.features.base.memsearch.gui.MemorySearchControlPanel;
import ghidra.features.base.memsearch.gui.MemorySearchOptions;
import ghidra.features.base.memsearch.gui.MemorySearchOptionsPanel;
import ghidra.features.base.memsearch.gui.MemorySearchPlugin;
import ghidra.features.base.memsearch.gui.MemorySearchResultsPanel;
import ghidra.features.base.memsearch.gui.SearchGuiModel;
import ghidra.features.base.memsearch.gui.SearchHistory;
import ghidra.features.base.memsearch.gui.SearchMarkers;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.scan.Scanner;
import ghidra.features.base.memsearch.searcher.AlignmentFilter;
import ghidra.features.base.memsearch.searcher.CodeUnitFilter;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.features.base.memsearch.searcher.MemorySearcher;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import resources.Icons;

public class MemorySearchProvider
extends ComponentProviderAdapter
implements DockingContextListener,
NavigatableRemovalListener,
DomainObjectClosedListener {
    private static final Icon SHOW_SEARCH_PANEL_ICON = new GIcon("icon.base.mem.search.panel.search");
    private static final Icon SHOW_SCAN_PANEL_ICON = new GIcon("icon.base.mem.search.panel.scan");
    private static final Icon SHOW_OPTIONS_ICON = new GIcon("icon.base.mem.search.panel.options");
    private static Set<Integer> USED_IDS = new HashSet<Integer>();
    private final int id = MemorySearchProvider.getId();
    private Navigatable navigatable;
    private Program program;
    private AddressableByteSource byteSource;
    private JComponent mainComponent;
    private JPanel controlPanel;
    private MemorySearchControlPanel searchPanel;
    private MemoryScanControlPanel scanPanel;
    private MemorySearchOptionsPanel optionsPanel;
    private MemorySearchResultsPanel resultsPanel;
    private ToggleDockingAction toggleOptionsPanelAction;
    private ToggleDockingAction toggleScanPanelAction;
    private ToggleDockingAction toggleSearchPanelAction;
    private DockingAction previousAction;
    private DockingAction nextAction;
    private DockingAction refreshAction;
    private ByteMatcher byteMatcher;
    private Address lastMatchingAddress;
    private boolean isBusy;
    private MemoryMatchHighlighter matchHighlighter;
    private MemorySearchPlugin plugin;
    private MemorySearchOptions options;
    private SearchGuiModel model;
    private boolean isPrivate = false;
    private GGlassPaneMessage glassPaneMessage;

    public MemorySearchProvider(MemorySearchPlugin plugin, Navigatable navigatable, SearchSettings settings, MemorySearchOptions options, SearchHistory history) {
        super(plugin.getTool(), "Memory Search", plugin.getName());
        this.plugin = plugin;
        this.navigatable = navigatable;
        this.options = options;
        this.program = navigatable.getProgram();
        this.byteSource = navigatable.getByteSource();
        if (settings == null) {
            settings = new SearchSettings();
        }
        settings = settings.withBigEndian(this.program.getMemory().isBigEndian());
        this.model = new SearchGuiModel(settings, this.byteSource.getSearchableRegions());
        this.model.setHasSelection(this.hasSelection(navigatable.getSelection()));
        this.model.setAutoRestrictSelection(options.isAutoRestrictSelection());
        this.setHelpLocation(new HelpLocation("Search", "Memory_Search"));
        SearchMarkers markers = new SearchMarkers(this.tool, this.getTitle(), this.program);
        this.searchPanel = new MemorySearchControlPanel(this, this.model, history);
        this.scanPanel = new MemoryScanControlPanel(this);
        this.optionsPanel = new MemorySearchOptionsPanel(this.model);
        this.resultsPanel = new MemorySearchResultsPanel(this, markers);
        this.mainComponent = this.buildMainComponent();
        this.matchHighlighter = new MemoryMatchHighlighter(navigatable, this.resultsPanel.getTableModel(), options);
        this.setTransient();
        this.addToTool();
        this.setVisible(true);
        this.createActions(plugin.getName());
        this.setDefaultFocusComponent(this.searchPanel.getDefaultFocusComponent());
        this.tool.addContextListener((DockingContextListener)this);
        navigatable.addNavigatableListener(this);
        this.program.addCloseListener((DomainObjectClosedListener)this);
        this.updateTitle();
    }

    public void setSearchInput(String input) {
        this.searchPanel.setSearchInput(input);
    }

    public String getSearchInput() {
        return this.byteMatcher == null ? "" : this.byteMatcher.getInput();
    }

    public void setSearchSelectionOnly(boolean b) {
        this.model.setSearchSelectionOnly(b);
    }

    void setPrivate() {
        this.isPrivate = true;
    }

    private void updateTitle() {
        StringBuilder builder = new StringBuilder();
        String searchInput = this.getSearchInput();
        builder.append("Search Memory: ");
        if (!searchInput.isBlank()) {
            builder.append("\"");
            builder.append(searchInput);
            builder.append("\"");
        }
        builder.append("  (");
        builder.append(this.getProgramName());
        builder.append(")");
        this.setTitle(builder.toString());
    }

    public JComponent getComponent() {
        return this.mainComponent;
    }

    void setByteMatcher(ByteMatcher byteMatcher) {
        this.byteMatcher = byteMatcher;
        this.tool.contextChanged((ComponentProvider)this);
    }

    void disableActionsFast() {
        this.nextAction.setEnabled(false);
        this.previousAction.setEnabled(false);
        this.refreshAction.setEnabled(false);
    }

    boolean canProcessResults() {
        return !this.isBusy && this.resultsPanel.hasResults();
    }

    private void searchOnce(boolean forward) {
        if (this.hasInvalidSearchSettings()) {
            return;
        }
        this.updateTitle();
        Address start = this.getSearchStartAddress(forward);
        AddressSet addresses = this.getSearchAddresses();
        MemorySearcher searcher = new MemorySearcher(this.byteSource, this.byteMatcher, (AddressSetView)addresses, 1);
        searcher.setMatchFilter(this.createFilter());
        this.setBusy(true);
        this.resultsPanel.searchOnce(searcher, start, forward);
        if (!this.isPrivate) {
            this.plugin.updateByteMatcher(this.byteMatcher);
        }
    }

    public void search() {
        if (this.hasInvalidSearchSettings()) {
            return;
        }
        this.updateTitle();
        int limit = this.options.getSearchLimit();
        AddressSet addresses = this.getSearchAddresses();
        MemorySearcher searcher = new MemorySearcher(this.byteSource, this.byteMatcher, (AddressSetView)addresses, limit);
        searcher.setMatchFilter(this.createFilter());
        this.setBusy(true);
        this.searchPanel.setSearchStatus(this.resultsPanel.hasResults(), true);
        this.resultsPanel.search(searcher, this.model.getMatchCombiner());
        if (!this.isPrivate) {
            this.plugin.updateByteMatcher(this.byteMatcher);
        }
    }

    private boolean hasInvalidSearchSettings() {
        Set<SearchRegion> selectedMemoryRegions = this.model.getSelectedMemoryRegions();
        if (selectedMemoryRegions.isEmpty()) {
            Msg.showInfo(this.getClass(), (Component)this.resultsPanel, (String)"No Memory Regions Selected!", (Object)"You must select one or more memory regions to perform a search!");
            return true;
        }
        if (!(this.model.includeInstructions() || this.model.includeDefinedData() || this.model.includeUndefinedData())) {
            Msg.showInfo(this.getClass(), (Component)this.resultsPanel, (String)"No Code Types Selected!", (Object)"You must select at least one of \"Instructions\", \"Defined Data\" or \"Undefined Data\" to perform a search!");
            return true;
        }
        return false;
    }

    public void scan(Scanner scanner) {
        this.setBusy(true);
        this.resultsPanel.refreshAndMaybeScanForChanges(this.byteSource, scanner);
    }

    private AddressSet getSearchAddresses() {
        AddressSet set = this.model.getSettings().getSearchAddresses(this.program);
        if (this.model.isSearchSelectionOnly()) {
            set = set.intersect((AddressSetView)this.navigatable.getSelection());
        }
        return set;
    }

    private void refreshResults() {
        this.setBusy(true);
        this.resultsPanel.refreshAndMaybeScanForChanges(this.byteSource, null);
    }

    private void setBusy(boolean isBusy) {
        this.isBusy = isBusy;
        boolean hasResults = this.resultsPanel.hasResults();
        this.searchPanel.setSearchStatus(hasResults, isBusy);
        this.scanPanel.setSearchStatus(hasResults, isBusy);
        if (isBusy) {
            this.disableActionsFast();
        }
        this.tool.contextChanged((ComponentProvider)this);
    }

    private Predicate<MemoryMatch> createFilter() {
        AlignmentFilter alignmentFilter = new AlignmentFilter(this.model.getAlignment());
        CodeUnitFilter codeUnitFilter = new CodeUnitFilter(this.program, this.model.includeInstructions(), this.model.includeDefinedData(), this.model.includeUndefinedData());
        return alignmentFilter.and(codeUnitFilter);
    }

    private Address getSearchStartAddress(boolean forward) {
        Address startAddress;
        ProgramLocation location = this.navigatable.getLocation();
        Address address = startAddress = location == null ? null : location.getByteAddress();
        if (startAddress == null) {
            Address address2 = startAddress = forward ? this.program.getMinAddress() : this.program.getMaxAddress();
        }
        if (this.lastMatchingAddress == null) {
            return startAddress;
        }
        CodeUnit cu = this.program.getListing().getCodeUnitContaining(startAddress);
        if (cu.contains(this.lastMatchingAddress)) {
            Address address3 = startAddress = forward ? this.lastMatchingAddress.next() : this.lastMatchingAddress.previous();
        }
        if (startAddress == null) {
            startAddress = this.program.getMinAddress();
        }
        return startAddress;
    }

    void searchAllCompleted(boolean foundResults, boolean cancelled, boolean terminatedEarly) {
        this.setBusy(false);
        this.updateSubTitle();
        if (!cancelled && terminatedEarly) {
            this.showAlert("Search Limit Exceeded!\n\nStopped search after finding " + this.options.getSearchLimit() + " matches.\nThe search limit can be changed at Edit \u2192 Tool Options, under Search.");
        } else if (!foundResults) {
            this.showAlert("No matches found!");
        }
    }

    void searchOnceCompleted(MemoryMatch match, boolean cancelled) {
        this.setBusy(false);
        this.updateSubTitle();
        if (match != null) {
            this.lastMatchingAddress = match.getAddress();
            this.navigatable.goTo(this.program, (ProgramLocation)new BytesFieldLocation(this.program, match.getAddress()));
        } else {
            this.showAlert("No Match Found!");
        }
    }

    void refreshAndScanCompleted(MemoryMatch match) {
        this.setBusy(false);
        this.updateSubTitle();
        if (match != null) {
            this.lastMatchingAddress = match.getAddress();
            this.navigatable.goTo(this.program, (ProgramLocation)new BytesFieldLocation(this.program, match.getAddress()));
        }
    }

    public void componentActivated() {
        this.resultsPanel.providerActivated();
        this.navigatable.setHighlightProvider(this.matchHighlighter, this.program);
    }

    private void updateSubTitle() {
        StringBuilder builder = new StringBuilder();
        builder.append(" ");
        int matchCount = this.resultsPanel.getMatchCount();
        if (matchCount > 0) {
            builder.append("(");
            builder.append(matchCount);
            builder.append(matchCount == 1 ? " entry)" : " entries)");
        }
        this.setSubTitle(builder.toString());
    }

    private String getProgramName() {
        return this.program.getDomainFile().getName();
    }

    private void updateControlPanel() {
        this.controlPanel.removeAll();
        boolean showSearchPanel = this.toggleSearchPanelAction.isSelected();
        boolean showScanPanel = this.toggleScanPanelAction.isSelected();
        if (showSearchPanel) {
            this.controlPanel.add(this.searchPanel);
        }
        if (showSearchPanel && showScanPanel) {
            this.controlPanel.add(new JSeparator());
        }
        if (showScanPanel) {
            this.controlPanel.add(this.scanPanel);
        }
        this.controlPanel.revalidate();
    }

    private void toggleShowScanPanel() {
        this.plugin.setShowScanPanel(this.toggleScanPanelAction.isSelected());
        this.updateControlPanel();
    }

    private void toggleShowSearchPanel() {
        this.updateControlPanel();
    }

    private void toggleShowOptions() {
        this.plugin.setShowOptionsPanel(this.toggleOptionsPanelAction.isSelected());
        if (this.toggleOptionsPanelAction.isSelected()) {
            this.mainComponent.add((Component)this.optionsPanel, "East");
        } else {
            this.mainComponent.remove(this.optionsPanel);
        }
        this.mainComponent.validate();
    }

    private boolean canSearch() {
        return !this.isBusy && this.byteMatcher != null && this.byteMatcher.isValidSearch();
    }

    private JComponent buildMainComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(900, 650));
        panel.add((Component)this.buildCenterPanel(), "Center");
        return panel;
    }

    private JComponent buildCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildControlPanel(), "North");
        panel.add((Component)this.resultsPanel, "Center");
        return panel;
    }

    private JComponent buildControlPanel() {
        this.controlPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        this.controlPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.controlPanel.add(this.searchPanel);
        return this.controlPanel;
    }

    private void createActions(String owner) {
        this.nextAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Search Next", owner).toolBarIcon(Icons.DOWN_ICON)).toolBarGroup("A")).description("Search forward for 1 result")).helpLocation(new HelpLocation("Search", "Search_Next"))).enabledWhen(c -> this.canSearch())).onAction(c -> this.searchOnce(true))).buildAndInstallLocal((ComponentProvider)this);
        this.previousAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Search Previous", owner).toolBarIcon(Icons.UP_ICON)).toolBarGroup("A")).description("Search backward for 1 result")).helpLocation(new HelpLocation("Search", "Search_Previous"))).enabledWhen(c -> this.canSearch())).onAction(c -> this.searchOnce(false))).buildAndInstallLocal((ComponentProvider)this);
        this.refreshAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Refresh Results", owner).toolBarIcon(Icons.REFRESH_ICON)).toolBarGroup("A")).description("Reload bytes from memory for each search result and show changes in red")).helpLocation(new HelpLocation("Search", "Refresh_Values"))).enabledWhen(c -> this.canProcessResults())).onAction(c -> this.refreshResults())).buildAndInstallLocal((ComponentProvider)this);
        this.toggleSearchPanelAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Show Memory Search Controls", owner).toolBarIcon(SHOW_SEARCH_PANEL_ICON)).toolBarGroup("Z")).description("Toggles showing the search controls")).helpLocation(new HelpLocation("Search", "Toggle_Search"))).selected(true).onAction(c -> this.toggleShowSearchPanel())).buildAndInstallLocal((ComponentProvider)this);
        this.toggleScanPanelAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Show Memory Scan Controls", owner).toolBarIcon(SHOW_SCAN_PANEL_ICON)).toolBarGroup("Z")).description("Toggles showing the scan controls")).helpLocation(new HelpLocation("Search", "Toggle_Scan"))).onAction(c -> this.toggleShowScanPanel())).buildAndInstallLocal((ComponentProvider)this);
        this.toggleOptionsPanelAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Show Options", owner).toolBarIcon(SHOW_OPTIONS_ICON)).toolBarGroup("Z")).description("Toggles showing the search options panel")).helpLocation(new HelpLocation("Search", "Toggle_Options"))).onAction(c -> this.toggleShowOptions())).buildAndInstallLocal((ComponentProvider)this);
        GhidraTable table = this.resultsPanel.getTable();
        this.addLocalAction((DockingActionIf)new MakeProgramSelectionAction(this.navigatable, owner, table));
        this.addLocalAction((DockingActionIf)new SelectionNavigationAction(owner, table));
        this.addLocalAction((DockingActionIf)new DeleteTableRowAction(table, owner){

            public void actionPerformed(ActionContext context) {
                super.actionPerformed(context);
                MemorySearchProvider.this.updateSubTitle();
                MemorySearchProvider.this.resultsPanel.itemDeleted();
            }
        });
    }

    public void closeComponent() {
        this.doClose(false);
    }

    private void doClose(boolean force) {
        if (force) {
            super.closeComponent();
            return;
        }
        if (!this.canClose()) {
            return;
        }
        super.closeComponent();
    }

    private boolean canClose() {
        boolean hasUserChanges = this.resultsPanel.hasUserChanges();
        if (!hasUserChanges) {
            return true;
        }
        String message = "Close dialog and lost custom search results?";
        OptionDialogBuilder builder = new OptionDialogBuilder("Close Results Window?", message);
        int choice = builder.addOption("Yes").addCancel().setDefaultButton("Yes").setMessageType(3).show((Component)this.resultsPanel);
        return choice == 1;
    }

    public void removeFromTool() {
        this.dispose();
        super.removeFromTool();
    }

    private void dispose() {
        if (this.glassPaneMessage != null) {
            this.glassPaneMessage.hide();
            this.glassPaneMessage = null;
        }
        this.matchHighlighter.dispose();
        USED_IDS.remove(this.id);
        if (this.navigatable != null) {
            this.navigatable.removeNavigatableListener(this);
        }
        this.resultsPanel.dispose();
        this.tool.removeContextListener((DockingContextListener)this);
        this.program.removeCloseListener((DomainObjectClosedListener)this);
    }

    public void contextChanged(ActionContext context) {
        this.model.setHasSelection(this.hasSelection(this.navigatable.getSelection()));
    }

    private boolean hasSelection(ProgramSelection selection) {
        if (selection == null) {
            return false;
        }
        return !selection.isEmpty();
    }

    @Override
    public void navigatableRemoved(Navigatable nav) {
        this.doClose(true);
    }

    public void domainObjectClosed(DomainObject dobj) {
        this.doClose(true);
    }

    Navigatable getNavigatable() {
        return this.navigatable;
    }

    private static int getId() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (USED_IDS.contains(i)) continue;
            USED_IDS.add(i);
            return i;
        }
        return 0;
    }

    void tableSelectionChanged() {
        MemoryMatch selectedMatch = this.resultsPanel.getSelectedMatch();
        this.matchHighlighter.setSelectedMatch(selectedMatch);
        if (selectedMatch != null) {
            this.lastMatchingAddress = selectedMatch.getAddress();
        }
        this.tool.contextChanged((ComponentProvider)this);
    }

    public void showOptions(boolean b) {
        this.toggleOptionsPanelAction.setSelected(b);
        this.toggleShowOptions();
    }

    public void showScanPanel(boolean b) {
        this.toggleScanPanelAction.setSelected(b);
        this.updateControlPanel();
    }

    public void showSearchPanel(boolean b) {
        this.toggleSearchPanelAction.setSelected(b);
        this.updateControlPanel();
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public List<MemoryMatch> getSearchResults() {
        return this.resultsPanel.getTableModel().getModelData();
    }

    public MemorySearchResultsPanel getResultsPanel() {
        return this.resultsPanel;
    }

    public void setSettings(SearchSettings settings) {
        String converted = this.searchPanel.convertInput(this.model.getSettings(), settings);
        this.model.setSettings(settings);
        this.searchPanel.setSearchInput(converted);
    }

    public void setSearchCombiner(Combiner combiner) {
        this.searchPanel.setSearchCombiner(combiner);
    }

    public boolean isSearchSelection() {
        return this.model.isSearchSelectionOnly();
    }

    public String getByteString() {
        return this.byteMatcher.getDescription();
    }

    protected ActionContext createContext(Component focusedComponent, Object contextObject) {
        NavigatableActionContext context = new NavigatableActionContext((ComponentProvider)this, this.navigatable);
        context.setContextObject(contextObject);
        context.setSourceObject(focusedComponent);
        GhidraTable table = this.resultsPanel.getTable();
        context.setSourceComponent((Component)((Object)table));
        return context;
    }

    private void showAlert(String message) {
        Toolkit.getDefaultToolkit().beep();
        if (this.glassPaneMessage == null) {
            GhidraTable table = this.resultsPanel.getTable();
            this.glassPaneMessage = new GGlassPaneMessage((JComponent)((Object)table));
            this.glassPaneMessage.setHideDelay(Duration.ofSeconds(3L));
        }
        this.glassPaneMessage.showCenteredMessage(message);
    }
}

