/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.panel;

import ghidra.features.base.codecompare.panel.CodeComparisonViewState;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import utility.function.Callback;

public class FunctionComparisonState {
    private static final String PROVIDER_SAVE_STATE_NAME = "FunctionComparison";
    private SaveState panelState = new SaveState();
    private CodeComparisonViewState viewState = new CodeComparisonViewState();
    private PluginTool tool;
    private List<Callback> updateCallbacks = new ArrayList<Callback>();

    public FunctionComparisonState(PluginTool tool) {
        this.tool = tool;
    }

    public SaveState getPanelState() {
        return this.panelState;
    }

    public CodeComparisonViewState getViewState() {
        return this.viewState;
    }

    public void setChanged() {
        this.tool.setConfigChanged(true);
    }

    public void writeConfigState(SaveState saveState) {
        saveState.putSaveState(PROVIDER_SAVE_STATE_NAME, this.panelState);
        this.viewState.writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        SaveState restoredPanelState = saveState.getSaveState(PROVIDER_SAVE_STATE_NAME);
        if (restoredPanelState != null) {
            this.panelState = restoredPanelState;
        }
        this.viewState.readConfigState(saveState);
        this.updateCallbacks.forEach(Callback::call);
    }

    public void addUpdateCallback(Callback callback) {
        this.updateCallbacks.add(Objects.requireNonNull(callback));
    }
}

