/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldUtils;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PreCommentFieldFactory
extends FieldFactory {
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String FIELD_NAME = "Pre-Comment";
    private static final String GROUP_TITLE = "Format Code";
    private static final String FIELD_GROUP_TITLE = "Pre-comments Field";
    public static final String ENABLE_WORD_WRAP_MSG = "Pre-comments Field.Enable Word Wrapping";
    public static final String ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG = "Pre-comments Field.Always Show the Automatic Comment";
    static final String FLAG_FUNCTION_ENTRY_OPTION = "Format Code.Flag Function Entry";
    static final String FLAG_SUBROUTINE_ENTRY_OPTION = "Format Code.Flag Subroutine Entry";
    static String FUNCTION_FLAG_COMMENT;
    static String SUBROUTINE_FLAG_COMMENT;
    private boolean flagFunctionEntry;
    private boolean flagSubroutineEntry;
    private boolean isWordWrap;
    private boolean alwaysShowAutomatic;
    private int automaticCommentStyle;

    public PreCommentFieldFactory() {
        super(FIELD_NAME);
    }

    private PreCommentFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        fieldOptions.registerOption(FLAG_FUNCTION_ENTRY_OPTION, (Object)false, null, "Toggles the display of a pre-comment for a function entry");
        fieldOptions.registerOption(FLAG_SUBROUTINE_ENTRY_OPTION, (Object)false, null, "Toggles the display of a pre-comment for a sub-routine entry");
        this.flagFunctionEntry = fieldOptions.getBoolean(FLAG_FUNCTION_ENTRY_OPTION, false);
        this.flagSubroutineEntry = fieldOptions.getBoolean(FLAG_SUBROUTINE_ENTRY_OPTION, false);
        this.automaticCommentStyle = displayOptions.getInt(OptionsGui.COMMENT_AUTO.getStyleOptionName(), -1);
        this.init(fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        int x = this.startX + varWidth;
        CodeUnit cu = (CodeUnit)obj;
        String[] autoComment = this.getAutoPreComments(cu);
        String[] comments = this.getDefinedPreComments(cu);
        List<String> offcutComments = CommentUtils.getOffcutComments(cu, CommentType.PRE);
        return this.getTextField(comments, autoComment, offcutComments, proxy, x);
    }

    private String[] getDefinedPreComments(CodeUnit cu) {
        Data data;
        int[] cpath;
        if (cu instanceof Data && (cpath = (data = (Data)cu).getComponentPath()).length > 0 && cpath[cpath.length - 1] == 0) {
            return null;
        }
        return cu.getCommentAsArray(CommentType.PRE);
    }

    private String[] getAutoPreComments(CodeUnit cu) {
        if (cu instanceof Instruction) {
            return this.getInstructionAutoComments((Instruction)cu);
        }
        return this.getDataAutoComments((Data)cu);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        String[] comment = cu.getCommentAsArray(CommentType.PRE);
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        return new CommentFieldLocation(cu.getProgram(), cu.getMinAddress(), cpath, comment, CommentType.PRE, row, col);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof CommentFieldLocation)) {
            return null;
        }
        CommentFieldLocation loc = (CommentFieldLocation)programLoc;
        if (loc.getCommentType() != CommentType.PRE) {
            return null;
        }
        return new FieldLocation(index, fieldNum, loc.getRow(), loc.getCharOffset());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions toolOptions, ToolOptions fieldOptions) {
        return new PreCommentFieldFactory(formatModel, provider, (Options)toolOptions, (Options)fieldOptions);
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(FLAG_FUNCTION_ENTRY_OPTION)) {
            this.flagFunctionEntry = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(FLAG_SUBROUTINE_ENTRY_OPTION)) {
            this.flagSubroutineEntry = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(ENABLE_WORD_WRAP_MSG)) {
            this.isWordWrap = (Boolean)newValue;
        } else if (optionName.equals(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG)) {
            this.alwaysShowAutomatic = (Boolean)newValue;
        }
    }

    private String[] getInstructionAutoComments(Instruction instr) {
        Symbol symbol;
        Function function;
        Program program = instr.getProgram();
        Address addr = instr.getMinAddress();
        if (this.flagFunctionEntry && (function = program.getListing().getFunctionAt(addr)) != null) {
            return new String[]{FUNCTION_FLAG_COMMENT};
        }
        if (this.flagSubroutineEntry && (symbol = program.getSymbolTable().getPrimarySymbol(addr)) != null) {
            boolean isSubroutine = false;
            ReferenceIterator iter = program.getReferenceManager().getReferencesTo(addr);
            while (iter.hasNext()) {
                Reference ref = iter.next();
                RefType refType = ref.getReferenceType();
                if (refType != RefType.CONDITIONAL_CALL && refType != RefType.UNCONDITIONAL_CALL) continue;
                isSubroutine = true;
                break;
            }
            if (isSubroutine) {
                return new String[]{SUBROUTINE_FLAG_COMMENT};
            }
        }
        return null;
    }

    private String[] getDataAutoComments(Data data) {
        return this.getPreceedingComponentAutoComment(data);
    }

    private String[] getPreceedingComponentAutoComment(Data data) {
        int levelsToIgnore = 0;
        String label = null;
        Address prevDataAddr = data.getMinAddress().previous();
        if (prevDataAddr == null) {
            return null;
        }
        int[] cpath = data.getComponentPath();
        if (cpath != null && cpath.length > 0) {
            if (cpath[cpath.length - 1] <= 0) {
                return null;
            }
            if ((data = data.getParent().getComponent(cpath[cpath.length - 1] - 1)) == null || !data.isStructure()) {
                return null;
            }
            levelsToIgnore = cpath.length - 1;
        } else {
            Program p = data.getProgram();
            if ((data = p.getListing().getDefinedDataContaining(prevDataAddr)) == null || !data.isStructure() && !data.isDynamic()) {
                return null;
            }
            Symbol s = p.getSymbolTable().getPrimarySymbol(data.getAddress());
            label = s != null ? s.getName(true) : data.getDataType().getName();
        }
        DataTypeComponent lastDtc = null;
        while (true) {
            DataType dt;
            if ((dt = data.getDataType()) instanceof Structure) {
                Structure struct = (Structure)dt;
                List components = struct.getComponentsContaining(struct.getLength());
                lastDtc = components.isEmpty() ? null : (DataTypeComponent)components.get(components.size() - 1);
            } else if (dt instanceof DynamicDataType) {
                DynamicDataType ddt = (DynamicDataType)dt;
                lastDtc = ddt.getComponentAt(data.getLength(), (MemBuffer)data);
                int lastDtcOrdinal = ddt.getNumComponents((MemBuffer)data) - 1;
                if (lastDtc != null && lastDtc.getOrdinal() < lastDtcOrdinal) {
                    lastDtc = ddt.getComponent(lastDtcOrdinal, (MemBuffer)data);
                }
            }
            if (lastDtc == null || lastDtc.getLength() == 0) break;
            Data component = data.getComponent(lastDtc.getOrdinal());
            if (component == null) {
                return null;
            }
            data = component;
        }
        if (lastDtc == null || lastDtc.isBitFieldComponent()) {
            return null;
        }
        return this.buildZeroLengthComponentAutoComment(lastDtc, data, levelsToIgnore, label);
    }

    private String[] buildZeroLengthComponentAutoComment(DataTypeComponent lastZeroLengthComponent, Data data, int levelsToIgnore, String label) {
        int cpathIndex;
        String fieldName = lastZeroLengthComponent.getFieldName();
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            fieldName = lastZeroLengthComponent.getDefaultFieldName();
        }
        StringBuilder flexName = new StringBuilder(fieldName);
        int[] cpath = data.getComponentPath();
        int n = cpathIndex = cpath != null ? cpath.length - 1 : -1;
        while (cpathIndex >= levelsToIgnore) {
            Data parent = data.getParent();
            Data component = parent.getComponent(cpath[cpathIndex--]);
            flexName.insert(0, component.getFieldName() + ".");
            data = component;
        }
        if (label != null) {
            flexName.insert(0, label + ".");
        }
        return new String[]{"Zero-length Component: " + lastZeroLengthComponent.getDataType().getName() + " " + flexName.toString()};
    }

    private ListingTextField getTextField(String[] comments, String[] autoComment, List<String> offcutComments, ProxyObj<?> proxy, int xStart) {
        int nLinesAutoComment;
        if (comments == null) {
            comments = EMPTY_STRING_ARRAY;
        }
        if (autoComment == null) {
            autoComment = EMPTY_STRING_ARRAY;
        }
        int n = nLinesAutoComment = comments.length == 0 || this.alwaysShowAutomatic ? autoComment.length : 0;
        if (comments.length == 0 && nLinesAutoComment == 0 && offcutComments.isEmpty()) {
            return null;
        }
        CodeUnit cu = (CodeUnit)proxy.getObject();
        Program program = cu.getProgram();
        AttributedString prototypeString = new AttributedString("prototype", (Color)ListingColors.CommentColors.PRE, this.getMetrics());
        List<Object> fields = new ArrayList<FieldElement>();
        for (int i = 0; i < nLinesAutoComment; ++i) {
            AttributedString as = new AttributedString(autoComment[i], (Color)ListingColors.CommentColors.AUTO, this.getMetrics(this.automaticCommentStyle), false, null);
            fields.add(new TextFieldElement(as, i, 0));
        }
        for (String comment : comments) {
            fields.add(CommentUtils.parseTextForAnnotations(comment, program, prototypeString, fields.size()));
        }
        for (String offcutComment : offcutComments) {
            AttributedString as = new AttributedString(offcutComment, (Color)ListingColors.CommentColors.OFFCUT, this.getMetrics(this.style), false, null);
            fields.add(new TextFieldElement(as, fields.size(), 0));
        }
        if (this.isWordWrap) {
            fields = FieldUtils.wrap(fields, (int)this.width);
        }
        return ListingTextField.createMultilineTextField(this, proxy, fields, xStart, this.width, this.hlProvider);
    }

    private void init(Options options) {
        int i;
        options.registerOption(ENABLE_WORD_WRAP_MSG, (Object)false, null, "Enables word wrapping.  When on, each line of text is wrapped as needed to fit within the current width.  When off, comments are displayed as entered by the user.  Lines that are too long for the field are truncated.");
        options.registerOption(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG, (Object)true, null, "Toggles the display of the automatic pre-comment");
        this.isWordWrap = options.getBoolean(ENABLE_WORD_WRAP_MSG, false);
        this.alwaysShowAutomatic = options.getBoolean(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG, true);
        if (FUNCTION_FLAG_COMMENT != null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        for (i = 0; i < 20; ++i) {
            sb.append("|");
        }
        sb.append(" FUNCTION ");
        for (i = 0; i < 50; ++i) {
            sb.append("|");
        }
        sb.append("\n");
        FUNCTION_FLAG_COMMENT = sb.toString();
        sb.setLength(0);
        sb.append("\n");
        for (i = 0; i < 19; ++i) {
            sb.append("|");
        }
        sb.append(" SUBROUTINE ");
        for (i = 0; i < 49; ++i) {
            sb.append("|");
        }
        sb.append("\n");
        SUBROUTINE_FLAG_COMMENT = sb.toString();
        options.registerOption(FLAG_SUBROUTINE_ENTRY_OPTION, (Object)false, null, "Toggle for whether a pre comment should be displayed at the entry point of a subroutine.");
        options.registerOption(FLAG_FUNCTION_ENTRY_OPTION, (Object)false, null, "Toggle for whether a pre comment should be displayed at the entry point of a function.");
    }
}

