/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FunctionOpenCloseField;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.FunctionProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionOpenCloseLocation;
import ghidra.program.util.ProgramLocation;
import java.math.BigInteger;

public class FunctionOpenCloseFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "+";

    public FunctionOpenCloseFieldFactory() {
        super(FIELD_NAME);
    }

    private FunctionOpenCloseFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.servicesChanged();
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        if (!this.enabled) {
            return null;
        }
        if (proxy instanceof FunctionProxy) {
            return new FunctionOpenCloseField(this, proxy, this.getMetrics(), this.startX + varWidth, this.width);
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj<?> proxy = bf.getProxy();
        if (proxy instanceof FunctionProxy) {
            FunctionProxy functionProxy = (FunctionProxy)proxy;
            Program program = functionProxy.getProgram();
            Address functionAddress = functionProxy.getFunctionAddress();
            return new FunctionOpenCloseLocation(program, functionAddress);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof FunctionOpenCloseLocation)) {
            return null;
        }
        return new FieldLocation(index, fieldNum, 0, 0);
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Function.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 2;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel fieldModel, ListingHighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new FunctionOpenCloseFieldFactory(fieldModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }
}

