/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.support.DefaultRowColLocation;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.proxy.EmptyProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class AbstractOpenCloseField
implements ListingField {
    protected static final Font HIDDEN_FONT = Gui.getFont((String)"font.listing.base.hidden.field");
    protected static final GIcon OPEN_ICON = new GIcon("icon.base.util.viewer.fieldfactory.openclose.open");
    protected static final GIcon CLOSED_ICON = new GIcon("icon.base.util.viewer.fieldfactory.openclose.closed");
    private FieldFactory factory;
    protected int startX;
    protected int startY;
    protected int fieldWidth;
    protected int heightAbove;
    protected int heightBelow;
    protected ProxyObj<?> proxy;
    protected boolean isOpen;
    protected int toggleHandleSize;

    public AbstractOpenCloseField(FieldFactory factory, ProxyObj<?> proxy, FontMetrics metrics, int x, int width) {
        this.factory = factory;
        this.proxy = proxy;
        this.fieldWidth = width;
        this.startX = x;
        this.heightAbove = metrics.getAscent();
        this.heightBelow = metrics.getLeading() + metrics.getDescent();
        this.toggleHandleSize = AbstractOpenCloseField.getOpenCloseHandleSize();
    }

    @Override
    public FieldFactory getFieldFactory() {
        return this.factory;
    }

    @Override
    public ProxyObj<?> getProxy() {
        if (this.proxy == null) {
            return EmptyProxy.EMPTY_PROXY;
        }
        return this.proxy;
    }

    public int getHeightAbove() {
        return this.heightAbove;
    }

    public int getHeightBelow() {
        return this.heightBelow;
    }

    public void setYPos(int yPos, int heightAbove, int heightBelow) {
        this.startY = yPos;
        this.heightAbove = heightAbove;
        this.heightBelow = heightBelow;
    }

    public int getPreferredWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.heightAbove + this.heightBelow;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setStartY(int startY) {
        this.startY = startY;
    }

    protected void paintCursor(Graphics g, Color cursorColor, RowColLocation cursorLoc) {
        if (cursorLoc != null) {
            g.setColor(cursorColor);
            Rectangle cursorBounds = this.getCursorBounds(cursorLoc.row(), cursorLoc.col());
            g.fillRect(cursorBounds.x, cursorBounds.y, cursorBounds.width, cursorBounds.height);
        }
    }

    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.fieldWidth && y >= this.startY && y < this.startY + this.heightAbove + this.heightBelow;
    }

    public int getNumDataRows() {
        return 1;
    }

    public int getNumRows() {
        return 1;
    }

    public int getNumCols(int row) {
        return 0;
    }

    public int getX(int row, int col) {
        return this.startX;
    }

    public int getY(int row) {
        return this.startY;
    }

    public int getRow(int y) {
        return 0;
    }

    public int getCol(int row, int x) {
        return 0;
    }

    public boolean isValid(int row, int col) {
        return row == 0 && col == 0;
    }

    public Rectangle getCursorBounds(int row, int col) {
        if (!this.isValid(row, col)) {
            return null;
        }
        return new Rectangle(this.startX, -this.heightAbove, 2, this.heightAbove + this.heightBelow);
    }

    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < this.startY || topOfScreen > this.startY + this.heightAbove + this.heightBelow) {
            return max;
        }
        if (direction > 0) {
            return this.heightAbove + this.heightBelow - (topOfScreen - this.startY);
        }
        return this.startY - topOfScreen;
    }

    public boolean isPrimary() {
        return false;
    }

    public void rowHeightChanged(int newHeightAbove, int newHeightBelow) {
        this.heightAbove = newHeightAbove;
        this.heightBelow = newHeightBelow;
    }

    public String getText() {
        return "";
    }

    public String getTextWithLineSeparators() {
        return "";
    }

    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        return new DefaultRowColLocation();
    }

    public int screenLocationToTextOffset(int row, int col) {
        return 0;
    }

    @Override
    public Object getClickedObject(FieldLocation fieldLocation) {
        return this;
    }

    public abstract void toggleOpenCloseState();

    static int getOpenCloseHandleSize() {
        return OPEN_ICON.getIconWidth();
    }
}

