/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.opinion.LibraryLookupTable;
import ghidra.app.util.opinion.LibrarySymbolTable;

class LibraryExportedSymbol {
    private String libName;
    private int memsize;
    private int ordinal = -1;
    private String symbolName;
    private String forwardLibraryName;
    private String forwardSymbolName;
    private int purge;
    private boolean noReturn;
    private String comment;

    LibraryExportedSymbol(String libName, int memsize, int ordinal, String symbolName, String forwardLibraryName, String forwardSymbolName, int purge, boolean noReturn, String comment) {
        this.libName = libName;
        this.memsize = memsize;
        this.ordinal = ordinal;
        this.symbolName = symbolName;
        this.purge = purge;
        this.noReturn = noReturn;
        this.comment = comment;
        this.forwardLibraryName = forwardLibraryName;
        this.forwardSymbolName = forwardSymbolName;
    }

    String getLibraryName() {
        return this.libName;
    }

    int getOrdinal() {
        return this.ordinal;
    }

    String getName() {
        return this.symbolName;
    }

    int getPurge() {
        if (this.isFowardEntry() && this.purge == -1) {
            this.processForwardedEntry();
        }
        if (this.purge == -2) {
            this.purge = -1;
        }
        return this.purge;
    }

    boolean hasNoReturn() {
        if (this.isFowardEntry() && this.purge == -1) {
            this.processForwardedEntry();
        }
        if (this.purge == -2) {
            this.purge = -1;
        }
        return this.noReturn;
    }

    private synchronized void processForwardedEntry() {
        this.purge = -2;
        LibrarySymbolTable lib = LibraryLookupTable.getSymbolTable(this.forwardLibraryName, this.memsize);
        if (lib == null) {
            return;
        }
        LibraryExportedSymbol libSym = lib.getSymbol(this.forwardSymbolName);
        if (libSym == null) {
            return;
        }
        this.purge = libSym.getPurge();
        if (this.purge != -1) {
            this.noReturn = libSym.hasNoReturn();
        }
    }

    String getComment() {
        return this.comment;
    }

    boolean isFowardEntry() {
        return this.forwardLibraryName != null;
    }

    String getFowardLibraryName() {
        return this.forwardLibraryName;
    }

    String getFowardSymbolName() {
        return this.forwardSymbolName;
    }

    void setName(String name) {
        this.symbolName = name;
    }
}

