/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.macho.dyld.LibObjcOptimization;
import ghidra.app.util.bin.format.objc.AbstractObjcTypeMetadata;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Category;
import ghidra.app.util.bin.format.objc.objc2.Objc2Class;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.app.util.bin.format.objc.objc2.Objc2ImageInfo;
import ghidra.app.util.bin.format.objc.objc2.Objc2InstanceVariable;
import ghidra.app.util.bin.format.objc.objc2.Objc2MessageReference;
import ghidra.app.util.bin.format.objc.objc2.Objc2Protocol;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Objc2TypeMetadata
extends AbstractObjcTypeMetadata {
    private Set<Address> refs = new HashSet<Address>();
    private List<Objc2ImageInfo> imageInfos = new ArrayList<Objc2ImageInfo>();
    private List<Objc2Category> categories = new ArrayList<Objc2Category>();
    private List<Objc2Class> classes = new ArrayList<Objc2Class>();
    private List<Objc2Protocol> protocols = new ArrayList<Objc2Protocol>();
    private List<Objc2MessageReference> messageRefs = new ArrayList<Objc2MessageReference>();

    public Objc2TypeMetadata(Program program, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        super(new ObjcState(program, Objc2Constants.CATEGORY_PATH), program, monitor, log);
        this.parse();
    }

    private void parse() throws IOException, CancelledException {
        try (MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider(this.program, false);){
            BinaryReader reader = new BinaryReader(provider, !this.program.getLanguage().isBigEndian());
            Map<String, List<MemoryBlock>> objcBlockMap = Arrays.stream(this.program.getMemory().getBlocks()).filter(b -> b.getName().startsWith("__objc_")).collect(Collectors.groupingBy(MemoryBlock::getName));
            this.parseLibObjcOptimization("__objc_opt_ro", objcBlockMap);
            this.parseRefs("__objc_classrefs", this.refs, objcBlockMap);
            this.parseRefs("__objc_superrefs", this.refs, objcBlockMap);
            this.parseRefs("__objc_protorefs", this.refs, objcBlockMap);
            this.parseRefs("__objc_selrefs", this.refs, objcBlockMap);
            this.parseRefs("__objc_nlclslist", this.refs, objcBlockMap);
            this.parseImageInfo("__objc_imageinfo", reader, objcBlockMap);
            this.parseCategoryList("__objc_catlist", reader, objcBlockMap);
            this.parseClassList("__objc_classlist", reader, objcBlockMap);
            this.parseProtocolList("__objc_protolist", reader, objcBlockMap);
            this.parseMessageReferences("__objc_msgrefs", reader, objcBlockMap);
        }
    }

    private void parseRefs(String section, Set<Address> set, Map<String, List<MemoryBlock>> objcBlockMap) throws CancelledException {
        this.monitor.setMessage("Parsing Objective-C %s references...".formatted(section));
        for (MemoryBlock block : objcBlockMap.getOrDefault(section, List.of())) {
            long count = block.getSize() / (long)this.program.getDefaultPointerSize();
            this.monitor.initialize((long)((int)count));
            Address address = block.getStart();
            int i = 0;
            while ((long)i < count) {
                this.monitor.increment();
                set.add(address);
                address = address.add((long)this.program.getDefaultPointerSize());
                ++i;
            }
        }
    }

    private void parseImageInfo(String section, BinaryReader reader, Map<String, List<MemoryBlock>> objcBlockMap) throws IOException {
        this.monitor.setMessage("Parsing Objective-C image infos...");
        for (MemoryBlock block : objcBlockMap.getOrDefault(section, List.of())) {
            Address address = block.getStart();
            reader.setPointerIndex(address.getOffset());
            this.imageInfos.add(new Objc2ImageInfo(this.program, this.state, reader));
        }
    }

    private void parseCategoryList(String section, BinaryReader reader, Map<String, List<MemoryBlock>> objcBlockMap) throws CancelledException {
        this.monitor.setMessage("Objective-C categories...");
        try {
            for (MemoryBlock block : objcBlockMap.getOrDefault(section, List.of())) {
                long count = block.getSize() / (long)this.program.getDefaultPointerSize();
                this.monitor.initialize((long)((int)count));
                Address address = block.getStart();
                int i = 0;
                while ((long)i < count) {
                    this.monitor.increment();
                    long categoryAddress = this.program.getDefaultPointerSize() == 4 ? reader.readUnsignedInt(address.getOffset()) : reader.readLong(address.getOffset());
                    reader.setPointerIndex(categoryAddress);
                    this.categories.add(new Objc2Category(this.program, this.state, reader));
                    this.refs.add(address);
                    address = address.add((long)this.program.getDefaultPointerSize());
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse Objective-C categeory from section '" + section + "'");
        }
    }

    private void parseClassList(String section, BinaryReader reader, Map<String, List<MemoryBlock>> objcBlockMap) throws CancelledException {
        this.monitor.setMessage("Objective-C classes...");
        try {
            for (MemoryBlock block : objcBlockMap.getOrDefault(section, List.of())) {
                long count = block.getSize() / (long)this.program.getDefaultPointerSize();
                this.monitor.initialize((long)((int)count));
                Address address = block.getStart();
                int i = 0;
                while ((long)i < count) {
                    this.monitor.increment();
                    long classAddress = this.program.getDefaultPointerSize() == 4 ? reader.readUnsignedInt(address.getOffset()) : reader.readLong(address.getOffset());
                    reader.setPointerIndex(classAddress);
                    this.classes.add(new Objc2Class(this.program, this.state, reader));
                    this.refs.add(address);
                    address = address.add((long)this.program.getDefaultPointerSize());
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse Objective-C class from section '" + section + "'");
        }
    }

    private void parseProtocolList(String section, BinaryReader reader, Map<String, List<MemoryBlock>> objcBlockMap) throws CancelledException {
        this.monitor.setMessage("Objective-C protocols...");
        try {
            for (MemoryBlock block : objcBlockMap.getOrDefault(section, List.of())) {
                long count = block.getSize() / (long)this.program.getDefaultPointerSize();
                this.monitor.initialize((long)((int)count));
                Address address = block.getStart();
                int i = 0;
                while ((long)i < count) {
                    this.monitor.increment();
                    long protocolAddress = this.program.getDefaultPointerSize() == 4 ? reader.readUnsignedInt(address.getOffset()) : reader.readLong(address.getOffset());
                    reader.setPointerIndex(protocolAddress);
                    Objc2Protocol protocol = new Objc2Protocol(this.program, this.state, reader);
                    this.protocols.add(protocol);
                    this.refs.add(address);
                    address = address.add((long)this.program.getDefaultPointerSize());
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse Objective-C protocol from section '" + section + "'");
        }
    }

    private void parseMessageReferences(String section, BinaryReader reader, Map<String, List<MemoryBlock>> objcBlockMap) throws CancelledException {
        this.monitor.setMessage("Objective-C message references...");
        try {
            for (MemoryBlock block : objcBlockMap.getOrDefault(section, List.of())) {
                long count = block.getSize() / (long)Objc2MessageReference.SIZEOF(this.program.getDefaultPointerSize());
                this.monitor.initialize((long)((int)count));
                Address address = block.getStart();
                int i = 0;
                while ((long)i < count) {
                    this.monitor.increment();
                    reader.setPointerIndex(address.getOffset());
                    this.messageRefs.add(new Objc2MessageReference(this.program, this.state, reader));
                    address = address.add((long)Objc2MessageReference.SIZEOF(this.program.getDefaultPointerSize()));
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse Objective-C message reference from section '" + section + "'");
        }
    }

    private void parseLibObjcOptimization(String section, Map<String, List<MemoryBlock>> objcBlockMap) throws CancelledException {
        this.monitor.setMessage("Parsing Objective-C libObjc optimizations...");
        try {
            for (MemoryBlock block : objcBlockMap.getOrDefault(section, List.of())) {
                this.monitor.checkCancelled();
                this.state.libObjcOptimization = new LibObjcOptimization(this.program, block.getStart());
            }
        }
        catch (IOException e) {
            this.log("Failed to parse Objective-C libObjc optimizations from section '" + section + "'");
        }
    }

    @Override
    public void applyTo() {
        for (Address addr : this.refs) {
            try {
                DataUtilities.createData((Program)this.program, (Address)addr, (DataType)new PointerDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_SINGLE_DATA);
            }
            catch (Exception e) {
                this.log("Failed to create pointer at " + String.valueOf(addr));
            }
        }
        for (Objc2ImageInfo imageInfo : this.imageInfos) {
            try {
                imageInfo.applyTo(this.program.getGlobalNamespace(), this.monitor);
            }
            catch (Exception e) {
                this.log("Failed to markup image info: " + String.valueOf(imageInfo));
            }
        }
        for (Objc2Category category : this.categories) {
            try {
                category.applyTo(this.program.getGlobalNamespace(), this.monitor);
            }
            catch (Exception e) {
                this.log("Failed to markup category: " + String.valueOf(category));
            }
        }
        for (Objc2Class cls : this.classes) {
            try {
                cls.applyTo(this.program.getGlobalNamespace(), this.monitor);
            }
            catch (Exception e) {
                this.log("Failed to markup class: " + String.valueOf(cls));
            }
        }
        for (Objc2Protocol protocol : this.protocols) {
            try {
                Namespace namespace = ObjcUtils.createNamespace(this.program, "objc", "Protocols", protocol.getName());
                protocol.applyTo(namespace, this.monitor);
            }
            catch (Exception e) {
                this.log("Failed to markup protocol: " + String.valueOf(protocol));
            }
        }
        for (Objc2MessageReference messageRef : this.messageRefs) {
            try {
                messageRef.applyTo(this.program.getGlobalNamespace(), this.monitor);
            }
            catch (Exception e) {
                this.log("Failed to markup message reference: " + String.valueOf(messageRef));
            }
        }
        ObjcUtils.createMethods(this.program, this.state, this.log, this.monitor);
        ObjcUtils.fixupReferences(Objc2Constants.getObjectiveC2SectionNames(), this.program, this.monitor);
        this.createInstanceVariables();
        ObjcUtils.setBlocksReadOnly(this.program.getMemory(), List.of("__objc_data", "__objc_classrefs", "__objc_msgrefs", "__objc_selrefs", "__objc_superrefs", "__objc_protorefs"));
    }

    private void createInstanceVariables() {
        this.monitor.initialize((long)this.state.variableMap.size(), "Creating Objective-C Instance Variables...");
        for (Address address : this.state.variableMap.keySet()) {
            if (this.monitor.isCancelled()) break;
            this.monitor.incrementProgress();
            Objc2InstanceVariable variable = this.state.variableMap.get(address);
            try {
                this.state.encodings.processInstanceVariableSignature(this.program, address, variable.getType(), variable.getSize());
            }
            catch (Exception e) {
                this.log("Unhandled instance variable signature: " + e.getMessage());
            }
        }
    }
}

