/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.app.util.bin.format.objc.objc2.Objc2Protocol;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Objc2ProtocolList
extends ObjcTypeMetadataStructure {
    public static final String NAME = "protocol_list_t";
    private List<Objc2Protocol> protocols = new ArrayList<Objc2Protocol>();

    public Objc2ProtocolList(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        long count = this.is32bit ? reader.readNextUnsignedInt() : reader.readNextLong();
        for (long i = 0L; i < count; ++i) {
            long protocolIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(protocolIndex);
            this.protocols.add(new Objc2Protocol(program, state, reader));
            reader.setPointerIndex(originalIndex);
        }
    }

    public long getCount() {
        return this.protocols.size();
    }

    public List<Objc2Protocol> getProtocols() {
        return this.protocols;
    }

    public static DataType toGenericDataType(boolean is32bit) throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        if (is32bit) {
            struct.add(DWORD, "count", null);
        } else {
            struct.add(QWORD, "count", null);
        }
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("protocol_list_t_" + this.protocols.size() + "_", 0);
        if (this.is32bit) {
            struct.add(DWORD, "count", null);
        } else {
            struct.add(QWORD, "count", null);
        }
        for (int i = 0; i < this.protocols.size(); ++i) {
            DataType dataType = this.protocols.get(i).toDataType();
            struct.add((DataType)new PointerDataType(dataType), this.pointerSize, "protocol" + i, null);
        }
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        Address address = ObjcUtils.toAddress(this.program, this.base);
        try {
            ObjcUtils.createData(this.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Namespace protocolListNamespace = ObjcUtils.createNamespace(this.program, "objc", NAME);
            ObjcUtils.createSymbol(this.program, protocolListNamespace, namespace.getName(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Objc2Protocol protocol : this.getProtocols()) {
            protocol.applyTo(namespace, monitor);
        }
    }
}

