/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.app.util.bin.format.objc.objc2.Objc2InstanceVariable;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Objc2InstanceVariableList
extends ObjcTypeMetadataStructure {
    public static final String NAME = "ivar_list_t";
    private int entsize;
    private int count;
    private List<Objc2InstanceVariable> ivars = new ArrayList<Objc2InstanceVariable>();

    public Objc2InstanceVariableList(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        this.entsize = reader.readNextInt();
        this.count = reader.readNextInt();
        for (int i = 0; i < this.count; ++i) {
            this.ivars.add(new Objc2InstanceVariable(program, state, reader));
        }
    }

    public long getEntsize() {
        return this.entsize;
    }

    public long getCount() {
        return this.count;
    }

    public List<Objc2InstanceVariable> getIvars() {
        return this.ivars;
    }

    public static DataType toGenericDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "entsize", null);
        struct.add(DWORD, "count", null);
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("ivar_list_t_" + this.count + "_", 0);
        struct.add(DWORD, "entsize", null);
        struct.add(DWORD, "count", null);
        for (int i = 0; i < this.ivars.size(); ++i) {
            struct.add(this.ivars.get(i).toDataType(), "var" + i, null);
        }
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        Address address = ObjcUtils.toAddress(this.program, this.base);
        try {
            ObjcUtils.createData(this.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Namespace instanceVariableNamespace = ObjcUtils.createNamespace(this.program, "objc", NAME);
            ObjcUtils.createSymbol(this.program, instanceVariableNamespace, namespace.getName(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Objc2InstanceVariable ivar : this.getIvars()) {
            ivar.applyTo(namespace, monitor);
        }
    }
}

