/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc2InstanceVariable
extends ObjcTypeMetadataStructure {
    private long offset;
    private String name;
    private String type;
    private int alignment;
    private int size;

    public Objc2InstanceVariable(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        long typeIndex;
        this.offset = ObjcUtils.readNextIndex(reader, this.is32bit);
        long nameIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (nameIndex > 0L && reader.isValidIndex(nameIndex)) {
            this.name = reader.readAsciiString(nameIndex);
        }
        if ((typeIndex = ObjcUtils.readNextIndex(reader, this.is32bit)) > 0L && reader.isValidIndex(typeIndex)) {
            this.type = reader.readAsciiString(typeIndex);
        }
        this.alignment = reader.readNextInt();
        this.size = reader.readNextInt();
    }

    public long getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("ivar_t", 0);
        if (this.is32bit) {
            struct.add((DataType)new PointerDataType(DWORD), this.pointerSize, "offset", null);
            struct.add((DataType)new PointerDataType(STRING), this.pointerSize, "name", null);
            struct.add((DataType)new PointerDataType(STRING), this.pointerSize, "type", null);
        } else {
            struct.add((DataType)new PointerDataType(QWORD), this.pointerSize, "offset", null);
            struct.add((DataType)new PointerDataType(STRING), this.pointerSize, "name", null);
            struct.add((DataType)new PointerDataType(STRING), this.pointerSize, "type", null);
        }
        struct.add(DWORD, "alignment", null);
        struct.add(DWORD, "size", null);
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.getOffset() == 0L) {
            return;
        }
        if (this.getName() == null && this.getName().length() == 0) {
            return;
        }
        Address address = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.getOffset());
        ObjcUtils.createSymbol(this.program, namespace, this.getName(), address);
        this.state.variableMap.put(address, this);
    }
}

