/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc2Implementation
extends ObjcTypeMetadataStructure {
    private boolean _isSmall = false;
    private long imp;

    public Objc2Implementation(Program program, ObjcState state, BinaryReader reader, boolean isSmall) throws IOException {
        super(program, state, reader.getPointerIndex());
        this._isSmall = isSmall;
        this.imp = isSmall ? this.base + (long)reader.readNextInt() : ObjcUtils.readNextIndex(reader, this.is32bit);
    }

    public Objc2Implementation(Program program, ObjcState state, BinaryReader reader) throws IOException {
        this(program, state, reader, false);
    }

    public long getImplementation() {
        return this.imp;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        if (this._isSmall) {
            return new TypedefDataType("ImplementationOffset", DWORD);
        }
        if (this.is32bit) {
            return new TypedefDataType("Implementation", DWORD);
        }
        return new TypedefDataType("Implementation", QWORD);
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
    }
}

