/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc2ImageInfo
extends ObjcTypeMetadataStructure {
    public static final int OBJC_IMAGE_IS_REPLACEMENT = 1;
    public static final int OBJC_IMAGE_SUPPORTS_GC = 2;
    public static final int OBJC_IMAGE_REQUIRES_GC = 4;
    private int version;
    private int flags;

    public Objc2ImageInfo(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        this.version = reader.readNextInt();
        this.flags = reader.readNextInt();
    }

    public int getVersion() {
        return this.version;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isReplacement() {
        return (this.flags & 1) != 0;
    }

    public boolean isSupportsGarbageCollection() {
        return (this.flags & 2) != 0;
    }

    public boolean isRequiresGarbageCollection() {
        return (this.flags & 4) != 0;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_image_info", 0);
        struct.add(DWORD, "version", null);
        struct.add(DWORD, "flags", null);
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        Address address = ObjcUtils.toAddress(this.program, this.base);
        ObjcUtils.createData(this.program, this.toDataType(), address);
    }
}

