/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.objc1.Objc1Category;
import ghidra.app.util.bin.format.objc.objc1.Objc1Class;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Objc1SymbolTable
extends ObjcTypeMetadataStructure {
    public static final String NAME = "objc_symtab";
    private int sel_ref_cnt;
    private int refs;
    private short cls_def_cnt;
    private short cat_def_cnt;
    private List<Objc1Class> classes = new ArrayList<Objc1Class>();
    private List<Objc1Category> categories = new ArrayList<Objc1Category>();

    Objc1SymbolTable(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        int i;
        this.sel_ref_cnt = reader.readNextInt();
        this.refs = reader.readNextInt();
        this.cls_def_cnt = reader.readNextShort();
        this.cat_def_cnt = reader.readNextShort();
        for (i = 0; i < this.cls_def_cnt; ++i) {
            long classIndex = reader.readNextInt();
            long oldClassIndex = reader.getPointerIndex();
            reader.setPointerIndex(classIndex);
            this.classes.add(new Objc1Class(program, state, reader));
            reader.setPointerIndex(oldClassIndex);
        }
        for (i = 0; i < this.cat_def_cnt; ++i) {
            long categoryIndex = reader.readNextInt();
            long oldCategoryIndex = reader.getPointerIndex();
            reader.setPointerIndex(categoryIndex);
            this.categories.add(new Objc1Category(program, state, reader));
            reader.setPointerIndex(oldCategoryIndex);
        }
    }

    public int getSelectorReferenceCount() {
        return this.sel_ref_cnt;
    }

    public int getRefs() {
        return this.refs;
    }

    public short getClassDefinitionCount() {
        return this.cls_def_cnt;
    }

    public short getCategoryDefinitionCount() {
        return this.cat_def_cnt;
    }

    public List<Objc1Class> getClasses() {
        return this.classes;
    }

    public List<Objc1Category> getCategories() {
        return this.categories;
    }

    public static DataType toGenericDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add(DWORD, "sel_ref_cnt", null);
        struct.add(DWORD, "refs", null);
        struct.add(WORD, "cls_def_cnt", null);
        struct.add(WORD, "cat_def_cnt", null);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        StructureDataType struct = new StructureDataType("objc_symtab_" + this.cls_def_cnt + "_" + this.cat_def_cnt + "_", 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add(DWORD, "sel_ref_cnt", null);
        struct.add(DWORD, "refs", null);
        struct.add(WORD, "cls_def_cnt", null);
        struct.add(WORD, "cat_def_cnt", null);
        for (i = 0; i < this.cls_def_cnt; ++i) {
            struct.add((DataType)PointerDataType.getPointer((DataType)this.classes.get(i).toDataType(), (int)this.pointerSize), "class" + i, null);
        }
        for (i = 0; i < this.cat_def_cnt; ++i) {
            struct.add((DataType)PointerDataType.getPointer((DataType)this.categories.get(i).toDataType(), (int)this.pointerSize), "category" + i, null);
        }
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.state.beenApplied.contains(this.base)) {
            return;
        }
        this.state.beenApplied.add(this.base);
        Address address = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.base);
        DataType dt = this.toDataType();
        try {
            DataUtilities.createData((Program)this.program, (Address)address, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)("Could not create " + dt.getName() + " @" + String.valueOf(address)));
        }
        this.program.getListing().getDefinedDataAt(address);
        for (Objc1Class clazz : this.classes) {
            clazz.applyTo(namespace, monitor);
        }
        for (Objc1Category category : this.categories) {
            category.applyTo(namespace, monitor);
        }
    }
}

