/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.app.util.bin.format.objc.objc1.Objc1Protocol;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Objc1ProtocolList
extends ObjcTypeMetadataStructure {
    public static final String NAME = "objc_protocol_list";
    private Objc1ProtocolList next;
    private int count;
    private List<Objc1Protocol> protocols = new ArrayList<Objc1Protocol>();

    Objc1ProtocolList(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        if (this.base == 0L) {
            return;
        }
        this.next = new Objc1ProtocolList(program, state, reader.clone(reader.readNextInt()));
        this.count = reader.readNextInt();
        for (int i = 0; i < this.count; ++i) {
            int protocolIndex = reader.readNextInt();
            long oldProtocolIndex = reader.getPointerIndex();
            reader.setPointerIndex(protocolIndex);
            this.protocols.add(new Objc1Protocol(program, state, reader));
            reader.setPointerIndex(oldProtocolIndex);
        }
    }

    public Objc1ProtocolList getNext() {
        return this.next;
    }

    public int getCount() {
        return this.count;
    }

    public List<Objc1Protocol> getProtocols() {
        return this.protocols;
    }

    public static DataType toGenericDataType(int pointerSize) throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)struct, (int)pointerSize), "next", null);
        struct.add(DWORD, "count", null);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_protocol_list_" + this.count + "_", 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1ProtocolList.toGenericDataType(this.pointerSize), (int)this.pointerSize), "next", null);
        struct.add(DWORD, "count", null);
        if (this.count > 0) {
            Pointer dt = PointerDataType.getPointer((DataType)this.protocols.get(0).toDataType(), (int)this.pointerSize);
            struct.add((DataType)new ArrayDataType((DataType)dt, this.count, dt.getLength()), "protocols", null);
        }
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.base == 0L) {
            return;
        }
        if (this.state.beenApplied.contains(this.base)) {
            return;
        }
        this.state.beenApplied.add(this.base);
        Address address = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.base);
        DataType dt = this.toDataType();
        this.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this.program.getListing().createData(address, dt);
        for (Objc1Protocol protocol : this.protocols) {
            if (monitor.isCancelled()) break;
            protocol.applyTo(namespace, monitor);
        }
    }
}

