/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethod;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Objc1Method
extends ObjcMethod {
    private String name;
    private String signature;
    private int address;

    Objc1Method(Program program, ObjcState state, BinaryReader reader, ObjcMethodType methodType) throws IOException {
        super(program, state, reader, methodType);
        this.name = ObjcUtils.dereferenceAsciiString(reader, this.is32bit);
        this.signature = ObjcUtils.dereferenceAsciiString(reader, this.is32bit);
        this.address = reader.readNextInt();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypes() {
        return this.signature;
    }

    @Override
    public long getImplementation() {
        return Integer.toUnsignedLong(this.address);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_method", 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "method_name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "method_types", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)VOID, (int)this.pointerSize), "method_imp", null);
        return struct;
    }
}

