/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.app.util.bin.format.objc.objc1.Objc1InstanceVariable;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Objc1InstanceVariableList
extends ObjcTypeMetadataStructure {
    public static final String NAME = "objc_method_list";
    private int ivar_count;
    private List<Objc1InstanceVariable> ivar_list = new ArrayList<Objc1InstanceVariable>();

    Objc1InstanceVariableList(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        if (this.base == 0L) {
            return;
        }
        this.ivar_count = reader.readNextInt();
        for (int i = 0; i < this.ivar_count; ++i) {
            this.ivar_list.add(new Objc1InstanceVariable(program, state, reader));
        }
    }

    public int getInstanceVariableCount() {
        return this.ivar_count;
    }

    public List<Objc1InstanceVariable> getInstanceVariables() {
        return this.ivar_list;
    }

    public static DataType toGenericDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add(DWORD, "ivar_count", null);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_ivar_list_" + this.ivar_count + "_", 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add(DWORD, "ivar_count", null);
        if (this.ivar_count > 0) {
            DataType dt = this.ivar_list.get(0).toDataType();
            struct.add((DataType)new ArrayDataType(dt, this.ivar_count, dt.getLength()), "ivar_list", null);
        }
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.base == 0L) {
            return;
        }
        if (this.state.beenApplied.contains(this.base)) {
            return;
        }
        this.state.beenApplied.add(this.base);
        Address address = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.base);
        DataType dt = this.toDataType();
        this.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this.program.getListing().createData(address, dt);
    }
}

