/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.listing.Program;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class Objc1Constants {
    public static final String NAMESPACE = "objc";
    public static final String CATEGORY = "/objc";
    public static final CategoryPath CATEGORY_PATH = new CategoryPath("/objc");
    private static final String SECTION_FIELD_NAME_PREFIX = "OBJC_SECTION_";
    public static final String OBJC_SECTION_CATEGORY = "__category";
    public static final String OBJC_SECTION_CATEGORY_CLASS_METHODS = "__cat_cls_meth";
    public static final String OBJC_SECTION_CATEGORY_INSTANCE_METHODS = "__cat_inst_meth";
    public static final String OBJC_SECTION_CLASS = "__class";
    public static final String OBJC_SECTION_CLASS_METHODS = "__cls_meth";
    public static final String OBJC_SECTION_CLASS_REFS = "__cls_refs";
    public static final String OBJC_SECTION_INSTANCE_METHODS = "__inst_meth";
    public static final String OBJC_SECTION_INSTANCE_VARS = "__instance_vars";
    public static final String OBJC_SECTION_MESSAGE_REFS = "__message_refs";
    public static final String OBJC_SECTION_METACLASS = "__meta_class";
    public static final String OBJC_SECTION_MODULE_INFO = "__module_info";
    public static final String OBJC_SECTION_PROTOCOL = "__protocol";
    public static final String OBJC_SECTION_SYMBOLS = "__symbols";
    public static final String OBJC_SECTION_DATA = "__data";
    public static final String READ_UNIX2003 = "_read$UNIX2003";
    public static final String OBJC_MSG_SEND = "_objc_msgSend";
    public static final String OBJC_MSG_SEND_WILDCARD = "_objc_msgSend*";
    public static final String OBJC_MSG_SEND_RTP_NAME = "_objc_msgSend_rtp";
    public static final long OBJ_MSGSEND_RTP = 0xFFFEFF00L;
    public static final long OBJ_MSGSEND_RTP_EXIT = 0xFFFF0000L;

    public static final List<String> getObjectiveCSectionNames() {
        Field[] declaredFields;
        ArrayList<String> sectionNames = new ArrayList<String>();
        for (Field field : declaredFields = Objc1Constants.class.getDeclaredFields()) {
            try {
                String name;
                Object object = field.get(null);
                if (!(object instanceof String) || !(name = (String)object).startsWith(SECTION_FIELD_NAME_PREFIX)) continue;
                sectionNames.add(name);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return sectionNames;
    }

    public static final boolean isObjectiveC(Program program) {
        String format = program.getExecutableFormat();
        if ("Mac OS X Mach-O".equals(format)) {
            for (String objcSection : Objc1Constants.getObjectiveCSectionNames()) {
                if (program.getMemory().getBlock(objcSection) == null || objcSection.equals(OBJC_SECTION_DATA)) continue;
                return true;
            }
        }
        return false;
    }
}

