/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.app.util.bin.format.objc.objc1.Objc1InstanceVariableList;
import ghidra.app.util.bin.format.objc.objc1.Objc1MetaClass;
import ghidra.app.util.bin.format.objc.objc1.Objc1MethodList;
import ghidra.app.util.bin.format.objc.objc1.Objc1ProtocolList;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc1Class
extends ObjcTypeMetadataStructure {
    public static final String NAME = "objc_class";
    public static final long SIZEOF = 48L;
    private Objc1MetaClass isa;
    private String super_class;
    private String name;
    private int version;
    private int info;
    private int instance_size;
    private Objc1InstanceVariableList variable_list;
    private Objc1MethodList method_list;
    private int cache;
    private Objc1ProtocolList protocols;
    private int unknown0;
    private int unknown1;

    public Objc1Class(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        this.isa = new Objc1MetaClass(program, state, reader.clone(reader.readNextInt()));
        this.super_class = ObjcUtils.dereferenceAsciiString(reader, this.is32bit);
        this.name = reader.readAsciiString(reader.readNextInt());
        this.version = reader.readNextInt();
        this.info = reader.readNextInt();
        this.instance_size = reader.readNextInt();
        this.variable_list = new Objc1InstanceVariableList(program, state, reader.clone(reader.readNextInt()));
        this.method_list = new Objc1MethodList(program, state, reader.clone(reader.readNextInt()), ObjcMethodType.INSTANCE);
        this.cache = reader.readNextInt();
        this.protocols = new Objc1ProtocolList(program, state, reader.clone(reader.readNextInt()));
        this.unknown0 = reader.readNextInt();
        this.unknown1 = reader.readNextInt();
    }

    public Objc1MetaClass getISA() {
        return this.isa;
    }

    public String getSuperClass() {
        return this.super_class;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public int getInfo() {
        return this.info;
    }

    public int getInstanceSize() {
        return this.instance_size;
    }

    public Objc1InstanceVariableList getInstanceVariableList() {
        return this.variable_list;
    }

    public Objc1MethodList getMethodList() {
        return this.method_list;
    }

    public int getCache() {
        return this.cache;
    }

    public Objc1ProtocolList getProtocols() {
        return this.protocols;
    }

    public int getUnknown0() {
        return this.unknown0;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)this.isa.toDataType(), (int)this.pointerSize), "isa", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "super_class", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "name", null);
        struct.add(DWORD, "version", null);
        struct.add(DWORD, "info", null);
        struct.add(DWORD, "instance_size", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1InstanceVariableList.toGenericDataType(), (int)this.pointerSize), "instance_vars", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1MethodList.toGenericDataType(this.pointerSize), (int)this.pointerSize), "method_lists", null);
        struct.add(DWORD, "cache", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1ProtocolList.toGenericDataType(this.pointerSize), (int)this.pointerSize), "protocols", null);
        struct.add(DWORD, "unknown0", null);
        struct.add(DWORD, "unknown1", null);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        Address address = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.base);
        DataType dt = this.toDataType();
        this.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this.program.getListing().createData(address, dt);
        this.program.getSymbolTable().createLabel(address, "objc_class_" + this.name, SourceType.ANALYSIS);
        Namespace classNamespace = ObjcUtils.getClassNamespace(this.program, null, this.name);
        this.isa.applyTo(namespace, monitor);
        this.variable_list.applyTo(namespace, monitor);
        this.method_list.applyTo(classNamespace, monitor);
    }
}

