/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.golang.GoFunctionMultiReturn;
import ghidra.app.util.bin.format.golang.GoParamStorageAllocator;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.LocalVariable;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GoFunctionFixup {
    private final Program program;
    private final Function func;
    private final GoParamStorageAllocator storageAllocator;
    private final FunctionSignature newSignature;
    private final String newCallingConv;
    private final DataTypeManager dtm;

    public GoFunctionFixup(Function func, GoVer goVersion) {
        this.program = func.getProgram();
        this.dtm = this.program.getDataTypeManager();
        this.func = func;
        this.storageAllocator = new GoParamStorageAllocator(this.program, goVersion);
        this.newSignature = func.getSignature();
        if (GoRttiMapper.isAbi0Func(func.getEntryPoint(), this.program)) {
            this.storageAllocator.setAbi0Mode();
            this.newCallingConv = "abi0";
        } else {
            this.newCallingConv = null;
        }
    }

    public GoFunctionFixup(Function func, FunctionSignature newSignature, String defaultCCName, GoParamStorageAllocator storageAllocator) {
        this.program = func.getProgram();
        this.dtm = this.program.getDataTypeManager();
        this.func = func;
        this.storageAllocator = storageAllocator;
        this.newSignature = newSignature;
        if (GoRttiMapper.isAbi0Func(func.getEntryPoint(), this.program)) {
            storageAllocator.setAbi0Mode();
            this.newCallingConv = "abi0";
        } else {
            this.newCallingConv = defaultCCName;
        }
    }

    public static boolean isClosureContext(ParameterDefinition p) {
        return ".context".equals(p.getName()) && p.getDataType() instanceof Pointer;
    }

    public static boolean isClosureContext(Parameter p) {
        return ".context".equals(p.getName()) && p.getDataType() instanceof Pointer;
    }

    public void apply() throws DuplicateNameException, InvalidInputException {
        ArrayList<Integer> spillVars = new ArrayList<Integer>();
        ArrayList<Parameter> newParams = new ArrayList<Parameter>();
        for (ParameterDefinition param : this.newSignature.getArguments()) {
            List<Register> regStorage;
            DataType dt = param.getDataType();
            ParameterImpl newParam = null;
            boolean isClosure = GoFunctionFixup.isClosureContext(param) && this.storageAllocator.getClosureContextRegister() != null;
            List<Register> list = regStorage = isClosure ? List.of(this.storageAllocator.getClosureContextRegister()) : this.storageAllocator.getRegistersFor(dt);
            if (regStorage != null && !regStorage.isEmpty()) {
                newParam = this.createParamWithCustomStorage(param.getName(), param.getDataType(), regStorage);
                if (!isClosure) {
                    spillVars.add(param.getOrdinal());
                }
                if (dt instanceof Structure && newParam.getVariableStorage().size() != dt.getLength()) {
                    MarkupSession.logWarningAt(this.program, this.func.getEntryPoint(), "Known storage allocation problem: param %s register allocation for structs missing inter-field padding.".formatted(newParam.toString()));
                }
            } else {
                newParam = this.createParamWithStackStorage(param.getName(), param.getDataType());
            }
            newParams.add((Parameter)newParam);
        }
        this.storageAllocator.alignStack();
        this.storageAllocator.resetRegAllocation();
        DataType returnDT = this.newSignature.getReturnType();
        ArrayList<LocalVariable> returnResultAliasVars = new ArrayList<LocalVariable>();
        ReturnParameterImpl returnParam = returnDT != null ? this.updateReturn(returnResultAliasVars) : null;
        this.storageAllocator.alignStack();
        if (!this.isEquivStorage(newParams, (Parameter)returnParam)) {
            this.func.updateFunction(this.newCallingConv, (Variable)returnParam, newParams, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.IMPORTED);
            if (!this.isEquivStorage(newParams, (Parameter)returnParam)) {
                this.func.updateFunction(this.newCallingConv, (Variable)returnParam, newParams, Function.FunctionUpdateType.CUSTOM_STORAGE, true, SourceType.IMPORTED);
            }
        }
        for (Variable localVar : this.func.getLocalVariables()) {
            if (!localVar.isStackVariable() || this.isInLocalVarStorageArea(localVar.getStackOffset())) continue;
            this.func.removeVariable(localVar);
        }
        Iterator iterator = spillVars.iterator();
        while (iterator.hasNext()) {
            int paramOrdinal = (Integer)iterator.next();
            Parameter param = this.func.getParameter(paramOrdinal);
            DataType paramDT = param.getFormalDataType();
            long stackOffset = this.storageAllocator.getStackAllocation(paramDT);
            Varnode stackVarnode = new Varnode(this.program.getAddressFactory().getStackSpace().getAddress(stackOffset), paramDT.getLength());
            VariableStorage varStorage = new VariableStorage((ProgramArchitecture)this.program, List.of(stackVarnode));
            String paramName = param.getName();
            if (paramName == null) {
                paramName = SymbolUtilities.getDefaultParamName((int)paramOrdinal);
            }
            LocalVariableImpl localVar = new LocalVariableImpl(paramName + "_spill", 0, paramDT, varStorage, this.program);
            this.func.addLocalVariable((Variable)localVar, SourceType.IMPORTED);
        }
        for (LocalVariable returnResultAliasVar : returnResultAliasVars) {
            this.func.addLocalVariable((Variable)returnResultAliasVar, SourceType.IMPORTED);
        }
        if (this.newSignature.hasNoReturn()) {
            this.func.setNoReturn(true);
        }
    }

    private boolean isEquivStorage(List<Parameter> newParams, Parameter returnParam) {
        boolean equivStorage = newParams.size() == this.func.getParameterCount();
        for (int i = 0; equivStorage && i < newParams.size(); ++i) {
            Parameter currentParam = this.func.getParameter(i);
            Parameter newParam = newParams.get(i);
            equivStorage = currentParam.getDataType().isEquivalent(newParam.getDataType()) && currentParam.getVariableStorage().equals((Object)newParam.getVariableStorage());
        }
        equivStorage = equivStorage && returnParam != null && this.func.getReturn() != null && this.func.getReturn().getVariableStorage().equals((Object)returnParam.getVariableStorage());
        return equivStorage;
    }

    public static DataType makeEmptyArrayDataType(DataType dt) {
        StructureDataType struct = new StructureDataType(dt.getCategoryPath(), ".empty_" + dt.getName(), 0, dt.getDataTypeManager());
        struct.setToDefaultPacking();
        return struct;
    }

    private ParameterImpl createParamWithCustomStorage(String name, DataType dt, List<Register> regStorage) throws InvalidInputException {
        List<Varnode> varnodes = DWARFUtil.convertRegisterListToVarnodeStorage(regStorage, dt.getLength());
        VariableStorage varStorage = new VariableStorage((ProgramArchitecture)this.program, (Varnode[])varnodes.toArray(Varnode[]::new));
        ParameterImpl newParam = new ParameterImpl(name, -2, dt, varStorage, true, this.program, SourceType.IMPORTED);
        return newParam;
    }

    private ParameterImpl createParamWithStackStorage(String name, DataType dt) throws InvalidInputException {
        if (!DWARFUtil.isZeroByteDataType(dt)) {
            long stackOffset = this.storageAllocator.getStackAllocation(dt);
            return new ParameterImpl(name, dt, (int)stackOffset, this.program);
        }
        if (DWARFUtil.isEmptyArray(dt)) {
            dt = GoFunctionFixup.makeEmptyArrayDataType(dt);
        }
        Address zerobaseAddress = GoRttiMapper.getZerobaseAddress(this.program);
        return new ParameterImpl(name, dt, zerobaseAddress, this.program, SourceType.IMPORTED);
    }

    private ReturnParameterImpl updateReturn(List<LocalVariable> returnResultAliasVars) throws InvalidInputException {
        DataType returnDT = this.newSignature.getReturnType();
        ArrayList<Varnode> varnodes = new ArrayList<Varnode>();
        if (returnDT == null || Undefined.isUndefined((DataType)returnDT)) {
            return null;
        }
        if (DWARFUtil.isVoid(returnDT)) {
            return new ReturnParameterImpl((DataType)VoidDataType.dataType, VariableStorage.VOID_STORAGE, this.program);
        }
        GoFunctionMultiReturn multiReturn = GoFunctionMultiReturn.fromStructure(returnDT, this.dtm, this.storageAllocator);
        if (multiReturn != null) {
            returnDT = multiReturn.getStruct();
            for (DataTypeComponent dtc : multiReturn.getComponentsInOriginalOrder()) {
                this.allocateReturnStorage(dtc.getFieldName() + "_return_result_alias", dtc.getDataType(), varnodes, returnResultAliasVars, false);
            }
            if (!this.program.getMemory().isBigEndian()) {
                GoFunctionFixup.reverseNonStackStorageLocations(varnodes);
            }
        } else if (DWARFUtil.isZeroByteDataType(returnDT)) {
            if (DWARFUtil.isEmptyArray(returnDT)) {
                returnDT = GoFunctionFixup.makeEmptyArrayDataType(returnDT);
            }
            varnodes.add(new Varnode(GoRttiMapper.getZerobaseAddress(this.program), 1));
        } else {
            this.allocateReturnStorage("return_value_alias_variable", returnDT, varnodes, returnResultAliasVars, true);
        }
        if (varnodes.isEmpty()) {
            return null;
        }
        VariableStorage varStorage = new VariableStorage((ProgramArchitecture)this.program, (Varnode[])varnodes.toArray(Varnode[]::new));
        return new ReturnParameterImpl(returnDT, varStorage, true, this.program);
    }

    private void allocateReturnStorage(String name_unused, DataType dt, List<Varnode> varnodes, List<LocalVariable> returnResultAliasVars, boolean allowEndianFixups) throws InvalidInputException {
        if (DWARFUtil.isZeroByteDataType(dt)) {
            return;
        }
        List<Register> regStorage = this.storageAllocator.getRegistersFor(dt, allowEndianFixups);
        if (regStorage != null && !regStorage.isEmpty()) {
            List<Varnode> nodes = DWARFUtil.convertRegisterListToVarnodeStorage(regStorage, dt.getLength());
            varnodes.addAll(nodes);
        } else {
            int prevIndex;
            Varnode prev;
            long stackOffset = this.storageAllocator.getStackAllocation(dt);
            LocalVariableImpl returnAliasLocalVar = new LocalVariableImpl(name_unused, dt, (int)stackOffset, this.program, SourceType.USER_DEFINED);
            returnResultAliasVars.add((LocalVariable)returnAliasLocalVar);
            if (!varnodes.isEmpty() && (prev = varnodes.get(prevIndex = this.storageAllocator.isBigEndian() ? varnodes.size() - 1 : 0)).getAddress().isStackAddress()) {
                Varnode updatedVN = new Varnode(prev.getAddress(), prev.getSize() + dt.getLength());
                varnodes.set(prevIndex, updatedVN);
                return;
            }
            varnodes.add(!this.storageAllocator.isBigEndian() ? 0 : varnodes.size(), new Varnode(this.program.getAddressFactory().getStackSpace().getAddress(stackOffset), dt.getLength()));
        }
    }

    private boolean isInLocalVarStorageArea(long stackOffset) {
        boolean paramsHavePositiveOffset = this.program.getCompilerSpec().stackGrowsNegative();
        return paramsHavePositiveOffset && stackOffset < 0L || !paramsHavePositiveOffset && stackOffset >= 0L;
    }

    public static void reverseNonStackStorageLocations(List<Varnode> varnodes) {
        int regStorageCount;
        for (regStorageCount = 0; regStorageCount < varnodes.size() && !DWARFUtil.isStackVarnode(varnodes.get(regStorageCount)); ++regStorageCount) {
        }
        ArrayList<Varnode> regStorageList = new ArrayList<Varnode>(varnodes.subList(0, regStorageCount));
        for (int i = 0; i < regStorageList.size(); ++i) {
            varnodes.set(i, (Varnode)regStorageList.get(regStorageList.size() - 1 - i));
        }
    }
}

