/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external.gui;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;

public class EnumIconColumnRenderer<E extends Enum<E>>
extends AbstractGColumnRenderer<E> {
    private Icon[] icons;
    private String[] toolTips;

    EnumIconColumnRenderer(Class<E> enumClass, Icon[] icons, String[] toolTips) {
        if (((Enum[])enumClass.getEnumConstants()).length != icons.length || icons.length != toolTips.length) {
            throw new IllegalArgumentException();
        }
        this.icons = icons;
        this.toolTips = toolTips;
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
        Enum e = (Enum)data.getValue();
        renderer.setHorizontalAlignment(0);
        renderer.setText("");
        renderer.setIcon(e != null ? this.icons[e.ordinal()] : null);
        renderer.setToolTipText(e != null ? this.toolTips[e.ordinal()] : null);
        return renderer;
    }

    protected String getText(Object value) {
        return "";
    }

    public String getFilterString(E t, Settings settings) {
        return t == null ? "" : ((Enum)t).toString();
    }
}

