/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.DebugFileProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderCreatorContext;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderStatus;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.CRC32;

public class LocalDirDebugLinkProvider
implements DebugFileProvider {
    private static final String DEBUGLINK_NAME_PREFIX = "debuglink://";
    private final File searchDir;

    public static boolean matches(String name) {
        return name.startsWith(DEBUGLINK_NAME_PREFIX);
    }

    public static LocalDirDebugLinkProvider create(String name, DebugInfoProviderCreatorContext context) {
        String dir = name.substring(DEBUGLINK_NAME_PREFIX.length());
        return new LocalDirDebugLinkProvider(new File(dir));
    }

    public LocalDirDebugLinkProvider(File searchDir) {
        this.searchDir = searchDir;
    }

    @Override
    public String getName() {
        return DEBUGLINK_NAME_PREFIX + this.searchDir.getPath();
    }

    @Override
    public String getDescriptiveName() {
        return this.searchDir.getPath() + " (debug-link dir)";
    }

    @Override
    public DebugInfoProviderStatus getStatus(TaskMonitor monitor) {
        return this.isValid() ? DebugInfoProviderStatus.VALID : DebugInfoProviderStatus.INVALID;
    }

    private boolean isValid() {
        return this.searchDir.isDirectory();
    }

    @Override
    public File getFile(ExternalDebugInfo debugInfo, TaskMonitor monitor) throws CancelledException, IOException {
        if (!debugInfo.hasDebugLink() || !this.isValid()) {
            return null;
        }
        this.ensureSafeFilename(debugInfo.getFilename());
        return this.findFile(this.searchDir, debugInfo, monitor);
    }

    private void ensureSafeFilename(String filename) throws IOException {
        File testFile = new File(this.searchDir, filename);
        if (!this.searchDir.equals(testFile.getParentFile())) {
            throw new IOException("Unsupported path specified in debug file: " + filename);
        }
    }

    File findFile(File dir, ExternalDebugInfo debugInfo, TaskMonitor monitor) throws IOException, CancelledException {
        File[] subDirs;
        if (!debugInfo.hasDebugLink()) {
            return null;
        }
        File file = new File(dir, debugInfo.getFilename());
        if (file.isFile()) {
            int fileCRC = LocalDirDebugLinkProvider.calcCRC(file);
            if (fileCRC == debugInfo.getCrc()) {
                return file;
            }
            Msg.info((Object)this, (Object)"DWARF external debug file found with mismatching crc, ignored: %s (%08x)".formatted(file, fileCRC));
        }
        if ((subDirs = dir.listFiles(f -> f.isDirectory())) != null) {
            for (File subDir : subDirs) {
                File result = this.findFile(subDir, debugInfo, monitor);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static int calcCRC(File f) throws IOException {
        byte[] bytes = new byte[65536];
        CRC32 crc32 = new CRC32();
        try (FileInputStream fis = new FileInputStream(f);){
            int bytesRead;
            while ((bytesRead = fis.read(bytes)) > 0) {
                crc32.update(bytes, 0, bytesRead);
            }
        }
        return (int)crc32.getValue();
    }
}

