/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderCreatorContext;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderStatus;
import ghidra.app.util.bin.format.dwarf.external.DebugStreamProvider;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf.external.ObjectType;
import ghidra.net.HttpClients;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpDebugInfoDProvider
implements DebugStreamProvider {
    private static final String GHIDRA_USER_AGENT = "Ghidra_HttpDebugInfoDProvider_client";
    private static final int HTTP_STATUS_OK = 200;
    private static final int HTTP_STATUS_INTERNAL_ERROR = 500;
    private static final int HTTP_STATUS_NOT_FOUND = 404;
    private static final int DEFAULT_HTTP_REQUEST_TIMEOUT_MS = 10000;
    private static final int DEFAULT_MAX_RETRY_COUNT = 5;
    private static final Pattern HTTPPROVIDER_REGEX = Pattern.compile("(http(s)?://.*)");
    private final URI serverURI;
    private int retriedCount;
    private int notFoundCount;
    private int maxRetryCount = 5;
    private int httpRequestTimeoutMs = 10000;

    public static boolean matches(String name) {
        return HTTPPROVIDER_REGEX.matcher(name).matches();
    }

    public static HttpDebugInfoDProvider create(String name, DebugInfoProviderCreatorContext context) {
        Matcher m = HTTPPROVIDER_REGEX.matcher(name);
        if (!m.matches()) {
            return null;
        }
        String uriStr = m.group(1);
        URI serverURI = URI.create(uriStr);
        return new HttpDebugInfoDProvider(serverURI);
    }

    public HttpDebugInfoDProvider(URI serverURI) {
        String path = serverURI.getPath();
        this.serverURI = path.endsWith("/") ? serverURI : serverURI.resolve(serverURI.getPath() + "/");
    }

    @Override
    public String getName() {
        return this.serverURI.toString();
    }

    @Override
    public String getDescriptiveName() {
        return this.serverURI.toString();
    }

    @Override
    public DebugInfoProviderStatus getStatus(TaskMonitor monitor) {
        return DebugInfoProviderStatus.UNKNOWN;
    }

    private HttpRequest.Builder request(ExternalDebugInfo id) throws IOException {
        try {
            Object extra = "";
            if (id.getObjectType() == ObjectType.SOURCE) {
                extra = "/" + Objects.requireNonNullElse(id.getExtra(), "");
            }
            String requestPath = "buildid/%s/%s%s".formatted(id.getBuildId(), id.getObjectType().getPathString(), extra);
            return HttpRequest.newBuilder(this.serverURI.resolve(requestPath)).setHeader("User-Agent", GHIDRA_USER_AGENT);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public DebugStreamProvider.StreamInfo getStream(ExternalDebugInfo id, TaskMonitor monitor) throws IOException, CancelledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpResponse<InputStream> tryGet(HttpRequest request, TaskMonitor monitor) throws IOException, CancelledException, TimeoutException {
        Msg.debug((Object)this, (Object)(this.logPrefix() + ": " + request.toString()));
        CompletableFuture<HttpResponse<InputStream>> futureResponse = HttpClients.getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofInputStream());
        CancelledListener l = () -> futureResponse.cancel(true);
        monitor.addCancelledListener(l);
        try {
            HttpResponse<InputStream> response;
            HttpResponse<InputStream> httpResponse = response = futureResponse.get(this.httpRequestTimeoutMs, TimeUnit.MILLISECONDS);
            return httpResponse;
        }
        catch (InterruptedException e) {
            throw new CancelledException("Download canceled");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioe = (IOException)cause;
                throw ioe;
            }
            Msg.error((Object)this, (Object)"Error during HTTP get", (Throwable)cause);
            throw new IOException("Error during HTTP get", cause);
        }
        finally {
            monitor.removeCancelledListener(l);
        }
    }

    private String logPrefix() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.serverURI) + "]";
    }

    private static void uncheckedClose(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getNotFoundCount() {
        return this.notFoundCount;
    }

    public int getRetriedCount() {
        return this.retriedCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public void setHttpRequestTimeoutMs(int httpRequestTimeoutMs) {
        this.httpRequestTimeoutMs = httpRequestTimeoutMs;
    }
}

