/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.ObjectType;
import ghidra.app.util.bin.format.elf.info.GnuDebugLink;
import ghidra.app.util.bin.format.elf.info.NoteGnuBuildId;
import ghidra.program.model.listing.Program;
import ghidra.util.NumericUtilities;

public class ExternalDebugInfo {
    private final String filename;
    private final int crc;
    private final String buildId;
    private final ObjectType objectType;
    private final String extra;

    public static ExternalDebugInfo fromProgram(Program program) {
        GnuDebugLink debugLink = GnuDebugLink.fromProgram(program);
        NoteGnuBuildId buildId = NoteGnuBuildId.fromProgram(program);
        if (debugLink == null && buildId == null) {
            return null;
        }
        String filename = debugLink != null ? debugLink.getFilename() : null;
        int crc = debugLink != null ? debugLink.getCrc() : 0;
        String hash = buildId != null ? NumericUtilities.convertBytesToString((byte[])buildId.getDescription()) : null;
        return new ExternalDebugInfo(filename, crc, hash, ObjectType.DEBUGINFO, null);
    }

    public static ExternalDebugInfo forBuildId(String buildId) {
        return new ExternalDebugInfo(null, 0, buildId, ObjectType.DEBUGINFO, null);
    }

    public static ExternalDebugInfo forDebugLink(String debugLinkFilename, int crc) {
        return new ExternalDebugInfo(debugLinkFilename, crc, null, ObjectType.DEBUGINFO, null);
    }

    public ExternalDebugInfo(String filename, int crc, String buildId, ObjectType objectType, String extra) {
        this.filename = filename;
        this.crc = crc;
        this.buildId = buildId;
        this.objectType = objectType;
        this.extra = extra;
    }

    public boolean hasDebugLink() {
        return this.filename != null && !this.filename.isBlank();
    }

    public String getFilename() {
        return this.filename;
    }

    public int getCrc() {
        return this.crc;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public boolean hasBuildId() {
        return this.buildId != null && !this.buildId.isBlank();
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String getExtra() {
        return this.extra;
    }

    public ExternalDebugInfo withType(ObjectType newObjectType, String newExtra) {
        return new ExternalDebugInfo(this.extra, this.crc, this.buildId, newObjectType, newExtra);
    }

    public String toString() {
        return String.format("ExternalDebugInfo [filename=%s, crc=%s, hash=%s, objectType=%s, extra=%s]", new Object[]{this.filename, this.crc, this.buildId, this.objectType, this.extra});
    }
}

