/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.BuildIdDebugFileProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderCreatorContext;
import ghidra.app.util.bin.format.dwarf.external.DisabledDebugInfoProvider;
import ghidra.app.util.bin.format.dwarf.external.HttpDebugInfoDProvider;
import ghidra.app.util.bin.format.dwarf.external.LocalDirDebugInfoDProvider;
import ghidra.app.util.bin.format.dwarf.external.LocalDirDebugLinkProvider;
import ghidra.app.util.bin.format.dwarf.external.SameDirDebugInfoProvider;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class DebugInfoProviderRegistry {
    private static final DebugInfoProviderRegistry instance = new DebugInfoProviderRegistry();
    private List<DebugInfoProviderCreationInfo> creators = new ArrayList<DebugInfoProviderCreationInfo>();

    public static DebugInfoProviderRegistry getInstance() {
        return instance;
    }

    public DebugInfoProviderRegistry() {
        this.register(DisabledDebugInfoProvider::matches, DisabledDebugInfoProvider::create);
        this.register(LocalDirDebugLinkProvider::matches, LocalDirDebugLinkProvider::create);
        this.register(SameDirDebugInfoProvider::matches, SameDirDebugInfoProvider::create);
        this.register(BuildIdDebugFileProvider::matches, BuildIdDebugFileProvider::create);
        this.register(LocalDirDebugInfoDProvider::matches, LocalDirDebugInfoDProvider::create);
        this.register(HttpDebugInfoDProvider::matches, HttpDebugInfoDProvider::create);
    }

    public void register(Predicate<String> testFunc, DebugInfoProviderCreator createFunc) {
        this.creators.add(new DebugInfoProviderCreationInfo(testFunc, createFunc));
    }

    public DebugInfoProviderCreatorContext newContext(Program program) {
        return new DebugInfoProviderCreatorContext(this, program);
    }

    public DebugInfoProvider create(String name, DebugInfoProviderCreatorContext context) {
        for (DebugInfoProviderCreationInfo slci : this.creators) {
            if (!slci.testFunc.test(name)) continue;
            return slci.createFunc.create(name, context);
        }
        return null;
    }

    private static interface DebugInfoProviderCreator {
        public DebugInfoProvider create(String var1, DebugInfoProviderCreatorContext var2);
    }

    private static class DebugInfoProviderCreationInfo {
        Predicate<String> testFunc;
        DebugInfoProviderCreator createFunc;

        DebugInfoProviderCreationInfo(Predicate<String> testFunc, DebugInfoProviderCreator createFunc) {
            this.testFunc = testFunc;
            this.createFunc = createFunc;
        }
    }
}

