/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.dnd.StringTransferable;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.terminal.TerminalProvider;
import ghidra.app.services.ClipboardContentProviderService;
import ghidra.app.util.ClipboardType;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.ArrayUtils;

public class TerminalClipboardProvider
implements ClipboardContentProviderService {
    protected static final ClipboardType TEXT_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Text");
    protected static final List<ClipboardType> COPY_TYPES = List.of(TEXT_TYPE);
    protected final TerminalProvider provider;
    protected FieldSelection selection;
    protected final Set<ChangeListener> listeners = new CopyOnWriteArraySet<ChangeListener>();

    public TerminalClipboardProvider(TerminalProvider provider) {
        this.provider = provider;
    }

    @Override
    public ComponentProvider getComponentProvider() {
        return this.provider;
    }

    @Override
    public Transferable copy(TaskMonitor monitor) {
        if (this.selection == null || this.selection.getNumRanges() != 1) {
            return null;
        }
        String text = this.provider.panel.getSelectedText(this.selection.getFieldRange(0));
        if (text == null) {
            return null;
        }
        return new StringTransferable(text);
    }

    @Override
    public Transferable copySpecial(ClipboardType copyType, TaskMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean paste(Transferable pasteData) {
        try {
            String text = (String)pasteData.getTransferData(DataFlavor.stringFlavor);
            this.provider.panel.paste(text);
            return true;
        }
        catch (UnsupportedFlavorException | IOException e) {
            return false;
        }
    }

    @Override
    public List<ClipboardType> getCurrentCopyTypes() {
        if (this.selection == null || this.selection.getNumRanges() == 0) {
            return List.of();
        }
        return COPY_TYPES;
    }

    @Override
    public boolean isValidContext(ActionContext context) {
        return context.getComponentProvider() == this.provider;
    }

    @Override
    public boolean enableCopy() {
        return true;
    }

    @Override
    public boolean enableCopySpecial() {
        return false;
    }

    @Override
    public boolean enablePaste() {
        return true;
    }

    @Override
    public void lostOwnership(Transferable transferable) {
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean canPaste(DataFlavor[] availableFlavors) {
        return -1 != ArrayUtils.indexOf((Object[])availableFlavors, (Object)DataFlavor.stringFlavor);
    }

    @Override
    public boolean canCopy() {
        return this.selection != null && this.selection.getNumRanges() == 1;
    }

    @Override
    public boolean canCopySpecial() {
        return false;
    }

    private void notifyStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            try {
                listener.stateChanged(event);
            }
            catch (Throwable t) {
                Msg.showError((Object)this, null, (String)"Error", (Object)t.getMessage(), (Throwable)t);
            }
        }
    }

    public void selectionChanged(FieldSelection selection) {
        this.selection = selection;
        this.notifyStateChanged();
    }

    @Override
    public String getClipboardActionOwner() {
        return this.provider.plugin.getName();
    }

    @Override
    public void customizeClipboardAction(DockingAction action) {
        switch (action.getName()) {
            case "Copy": {
                action.setKeyBindingData(new KeyBindingData(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40));
                break;
            }
            case "Paste": {
                action.setKeyBindingData(new KeyBindingData(86, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40));
            }
        }
    }
}

