/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.services.BlockModelService;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.ProgramLocationTableColumn;
import ghidra.util.table.field.ReferenceFromAddressTableColumn;
import ghidra.util.table.field.ReferenceFromLabelTableColumn;
import ghidra.util.table.field.ReferenceFromPreviewTableColumn;
import ghidra.util.table.field.ReferenceTypeTableColumn;
import ghidra.util.task.TaskMonitor;

public class SymbolReferenceModel
extends AddressBasedTableModel<Reference> {
    static final int ADDRESS_COLUMN = 0;
    static final int LABEL_COL = 1;
    static final int SUBROUTINE_COL = 2;
    static final int ACCESS_COL = 3;
    static final int PREVIEW_COL = 4;
    static final String ADDR_COL_NAME = "Address";
    static final String LABEL_COL_NAME = "Label";
    static final String SUBROUTINE_COL_NAME = "Subroutine";
    static final String ACCESS_COL_NAME = "Access";
    static final String PREVIEW_COL_NAME = "Preview";
    static final int REFS_TO = 0;
    static final int INSTR_REFS_FROM = 1;
    static final int DATA_REFS_FROM = 2;
    private volatile Symbol currentSymbol;
    private ReferenceManager refManager;
    private int showRefMode = 0;
    private BlockModelService blockModelService;

    SymbolReferenceModel(BlockModelService bms, PluginTool tool) {
        super("Symbol References", (ServiceProvider)tool, null, null);
        this.blockModelService = bms;
    }

    @Override
    protected TableColumnDescriptor<Reference> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new ReferenceFromAddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new ReferenceFromLabelTableColumn()));
        descriptor.addVisibleColumn((DynamicTableColumn)new SubroutineTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ReferenceTypeTableColumn());
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new ReferenceFromPreviewTableColumn()));
        return descriptor;
    }

    String getDescription() {
        if (this.isDisposed) {
            return null;
        }
        Object description = "";
        if (this.currentSymbol != null) {
            description = (String)description + this.currentSymbol.getName() + ": ";
        }
        int count = this.filteredData.size();
        description = (String)description + count + " Reference";
        if (count != 1) {
            description = (String)description + "s";
        }
        return description;
    }

    @Override
    public void setProgram(Program prog) {
        if (this.isDisposed) {
            return;
        }
        if (prog == null) {
            super.setProgram(null);
            this.refManager = null;
        } else {
            super.setProgram(prog);
            this.refManager = prog.getReferenceManager();
        }
        this.currentSymbol = null;
        this.reload();
    }

    void setCurrentSymbol(Symbol symbol) {
        this.currentSymbol = symbol;
        this.reload();
    }

    void symbolAdded(Symbol symbol) {
        this.checkRefs(symbol);
    }

    void symbolRemoved(long symbolId) {
        if (this.currentSymbol != null && this.currentSymbol.getID() == symbolId) {
            this.setCurrentSymbol(null);
        }
    }

    void symbolChanged(Symbol symbol) {
        if (this.currentSymbol != null && this.currentSymbol.equals((Object)symbol)) {
            return;
        }
        this.checkRefs(symbol);
    }

    private void checkRefs(Symbol symbol) {
        for (Reference ref : this.filteredData) {
            if (!ref.getFromAddress().equals((Object)symbol.getAddress())) continue;
            this.reload();
            return;
        }
    }

    void showReferencesTo() {
        this.showRefMode = 0;
        this.reload();
    }

    void showInstructionReferencesFrom() {
        this.showRefMode = 1;
        this.reload();
    }

    void showDataReferencesFrom() {
        this.showRefMode = 2;
        this.reload();
    }

    protected void doLoad(Accumulator<Reference> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.currentSymbol == null || this.getProgram() == null) {
            return;
        }
        switch (this.showRefMode) {
            case 0: {
                this.loadToReferences(accumulator, monitor);
                break;
            }
            case 1: {
                this.loadFromReferences(accumulator, true, monitor);
                break;
            }
            case 2: {
                this.loadFromReferences(accumulator, false, monitor);
            }
        }
    }

    private void loadToReferences(Accumulator<Reference> accumulator, TaskMonitor monitor) throws CancelledException {
        Reference[] refs;
        if (this.refManager == null) {
            return;
        }
        for (Reference ref : refs = this.currentSymbol.getReferences(monitor)) {
            monitor.checkCancelled();
            accumulator.add((Object)ref);
        }
    }

    private void loadFromReferences(Accumulator<Reference> accumulator, boolean isInstr, TaskMonitor monitor) throws CancelledException {
        CodeBlockModel blockModel = this.blockModelService.getActiveSubroutineModel(this.getProgram());
        CodeBlock block = blockModel.getCodeBlockAt(this.currentSymbol.getAddress(), TaskMonitor.DUMMY);
        if (block == null) {
            return;
        }
        InstructionIterator ii = this.getProgram().getListing().getInstructions((AddressSetView)block, true);
        while (ii.hasNext()) {
            Reference[] references;
            monitor.checkCancelled();
            Instruction instr = ii.next();
            for (Reference reference : references = instr.getReferencesFrom()) {
                RefType rt = reference.getReferenceType();
                if (isInstr) {
                    if (rt.isFlow()) {
                        accumulator.add((Object)reference);
                        continue;
                    }
                    if (!instr.getFlowType().isComputed() || references.length != 1 || rt != RefType.READ) continue;
                    accumulator.add((Object)reference);
                    continue;
                }
                if (!rt.isData()) continue;
                accumulator.add((Object)reference);
            }
        }
    }

    private static Symbol getSymbol(Address fromAddress, String symbolName, BlockModelService blockModelService, Program program) {
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator iterator = symbolTable.getSymbols(symbolName);
        while (iterator.hasNext()) {
            CodeBlockModel blockModel;
            Symbol symbol = iterator.next();
            CodeBlock[] blocks = SymbolReferenceModel.getCodeBlocksContainingSymbol(symbol, blockModel = blockModelService.getActiveSubroutineModel(program));
            if (blocks == null || blocks.length == 0) continue;
            for (CodeBlock block : blocks) {
                if (!block.contains(fromAddress)) continue;
                return symbol;
            }
        }
        return null;
    }

    private static CodeBlock[] getCodeBlocksContainingSymbol(Symbol symbol, CodeBlockModel blockModel) {
        return SymbolReferenceModel.getCodeBlocksContainingAddress(symbol.getAddress(), blockModel);
    }

    private static CodeBlock[] getCodeBlocksContainingAddress(Address address, CodeBlockModel blockModel) {
        try {
            return blockModel.getCodeBlocksContaining(address, TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            return null;
        }
    }

    private static String getSubroutineName(Reference reference, BlockModelService service, Program program, CodeBlockModel model) {
        Address address = reference.getFromAddress();
        CodeBlock[] blocks = SymbolReferenceModel.getCodeBlocksContainingAddress(address, model);
        if (blocks != null && blocks.length > 0) {
            return blocks[0].getName();
        }
        return null;
    }

    @Override
    public Address getAddress(int row) {
        return (Address)this.getValueAt(row, 0);
    }

    private static class SubroutineTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Reference, String>
    implements ProgramLocationTableColumn<Reference, String> {
        private Program cachedProgram;
        private CodeBlockModel cachedModel;

        private SubroutineTableColumn() {
        }

        public String getColumnName() {
            return SymbolReferenceModel.SUBROUTINE_COL_NAME;
        }

        public String getValue(Reference rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            BlockModelService service = (BlockModelService)serviceProvider.getService(BlockModelService.class);
            CodeBlockModel model = this.getCodeBlockModel(program, service);
            return SymbolReferenceModel.getSubroutineName(rowObject, service, program, model);
        }

        private CodeBlockModel getCodeBlockModel(Program program, BlockModelService service) {
            if (this.cachedModel == null || program != this.cachedProgram) {
                CodeBlockModel model;
                this.cachedModel = model = service.getActiveSubroutineModel(program);
            }
            this.cachedProgram = program;
            return this.cachedModel;
        }

        @Override
        public ProgramLocation getProgramLocation(Reference rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            CodeBlockModel model;
            BlockModelService service = (BlockModelService)serviceProvider.getService(BlockModelService.class);
            String subroutineName = SymbolReferenceModel.getSubroutineName(rowObject, service, program, model = this.getCodeBlockModel(program, service));
            if (subroutineName == null) {
                return null;
            }
            Symbol symbol = SymbolReferenceModel.getSymbol(rowObject.getFromAddress(), subroutineName, service, program);
            if (symbol != null) {
                return symbol.getProgramLocation();
            }
            return null;
        }
    }
}

