/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview.addresstype;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingActionIf;
import generic.theme.GColor;
import ghidra.app.plugin.core.overview.AbstractColorOverviewAction;
import ghidra.app.plugin.core.overview.OverviewColorComponent;
import ghidra.app.plugin.core.overview.OverviewColorLegendDialog;
import ghidra.app.plugin.core.overview.OverviewColorService;
import ghidra.app.plugin.core.overview.addresstype.AddressType;
import ghidra.app.plugin.core.overview.addresstype.AddressTypeOverviewLegendPanel;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class AddressTypeOverviewColorService
implements OverviewColorService,
OptionsChangeListener,
DomainObjectListener {
    private static final String OPTIONS_NAME = "Overview";
    private static final GColor DEFAULT_INSTRUCTION_COLOR = new GColor("color.bg.plugin.overview.address.instruction");
    private static final GColor DEFAULT_DATA_COLOR = new GColor("color.bg.plugin.overview.address.data");
    private static final GColor DEFAULT_FUNCTION_COLOR = new GColor("color.bg.plugin.overview.address.function");
    private static final GColor DEFAULT_UNDEFINED_COLOR = new GColor("color.bg.plugin.overview.address.undefined");
    private static final GColor DEFAULT_UNINITIALIZED_COLOR = new GColor("color.bg.plugin.overview.address.uninitialized");
    private static final GColor DEFAULT_EXTERNAL_REF_COLOR = new GColor("color.bg.plugin.overview.address.external.ref");
    Color instructionColor = DEFAULT_INSTRUCTION_COLOR;
    Color dataColor = DEFAULT_DATA_COLOR;
    Color functionColor = DEFAULT_FUNCTION_COLOR;
    Color undefinedColor = DEFAULT_UNDEFINED_COLOR;
    Color uninitializedColor = DEFAULT_UNINITIALIZED_COLOR;
    Color externalRefColor = DEFAULT_EXTERNAL_REF_COLOR;
    private Program program;
    private Listing listing;
    private OverviewColorComponent overviewComponent;
    private PluginTool tool;
    private AddressTypeOverviewLegendPanel legendPanel;

    @Override
    public String getName() {
        return OPTIONS_NAME;
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("OverviewPlugin", "AddressTypeOverviewBar");
    }

    @Override
    public Color getColor(Address address) {
        AddressType type = this.getAddressType(address);
        return this.getColor(type);
    }

    @Override
    public String getToolTipText(Address address) {
        if (address == null) {
            return "";
        }
        AddressType addressType = this.getAddressType(address);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<b>");
        buffer.append(HTMLUtilities.escapeHTML((String)this.getName()));
        buffer.append("</b>\n");
        buffer.append(addressType.getDescription());
        buffer.append(" (");
        buffer.append(HTMLUtilities.escapeHTML((String)this.getBlockName(address)));
        buffer.append(" ");
        buffer.append(address);
        buffer.append(" )");
        return HTMLUtilities.toWrappedHTML((String)buffer.toString(), (int)0);
    }

    @Override
    public List<DockingActionIf> getActions() {
        ArrayList<DockingActionIf> actions = new ArrayList<DockingActionIf>();
        actions.add((DockingActionIf)new AbstractColorOverviewAction("Show Legend", this.getName(), this.overviewComponent, this.getHelpLocation()){

            public void actionPerformed(ActionContext context) {
                AddressTypeOverviewColorService.this.tool.showDialog(AddressTypeOverviewColorService.this.getLegendDialog());
            }
        });
        return actions;
    }

    @Override
    public void setProgram(Program program) {
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this);
        }
        this.program = program;
        Listing listing = this.listing = program == null ? null : program.getListing();
        if (this.program != null) {
            this.program.addListener((DomainObjectListener)this);
        }
    }

    @Override
    public void initialize(PluginTool pluginTool) {
        this.tool = pluginTool;
        this.registerOptions();
        this.readOptions();
    }

    @Override
    public void setOverviewComponent(OverviewColorComponent component) {
        this.overviewComponent = component;
        this.overviewComponent.getAccessibleContext().setAccessibleName("Address Type Overview Component");
    }

    public Color getColor(AddressType addressType) {
        switch (addressType) {
            case FUNCTION: {
                return this.functionColor;
            }
            case UNINITIALIZED: {
                return this.uninitializedColor;
            }
            case EXTERNAL_REF: {
                return this.externalRefColor;
            }
            case INSTRUCTION: {
                return this.instructionColor;
            }
            case DATA: {
                return this.dataColor;
            }
            case UNDEFINED: {
                return this.undefinedColor;
            }
        }
        return this.uninitializedColor;
    }

    public AddressType getAddressType(Address address) {
        if (this.listing == null || address == null) {
            return AddressType.UNINITIALIZED;
        }
        if (this.isInFunction(address)) {
            return AddressType.FUNCTION;
        }
        CodeUnit codeUnit = this.listing.getCodeUnitContaining(address);
        if (codeUnit == null) {
            return AddressType.UNINITIALIZED;
        }
        if (this.hasExternalReference(codeUnit)) {
            return AddressType.EXTERNAL_REF;
        }
        if (codeUnit instanceof Instruction) {
            return AddressType.INSTRUCTION;
        }
        if (codeUnit instanceof Data && ((Data)codeUnit).isDefined()) {
            return AddressType.DATA;
        }
        if (this.isInInitializedBlock(address)) {
            return AddressType.UNDEFINED;
        }
        return AddressType.UNINITIALIZED;
    }

    public void setColor(AddressType type, Color newColor) {
        ToolOptions options = this.tool.getOptions(OPTIONS_NAME);
        switch (type) {
            case DATA: {
                options.setColor("Data Color", newColor);
                break;
            }
            case EXTERNAL_REF: {
                options.setColor("External Reference Color", newColor);
                break;
            }
            case FUNCTION: {
                options.setColor("Function Color", newColor);
                break;
            }
            case INSTRUCTION: {
                options.setColor("Instruction Color", newColor);
                break;
            }
            case UNDEFINED: {
                options.setColor("Undefined Color", newColor);
                break;
            }
            case UNINITIALIZED: {
                options.setColor("Uninitialized Color", newColor);
                break;
            }
        }
    }

    private boolean isInFunction(Address address) {
        return this.listing.getFunctionContaining(address) != null;
    }

    private boolean isInInitializedBlock(Address address) {
        MemoryBlock block = this.program.getMemory().getBlock(address);
        return block != null && block.isInitialized();
    }

    private boolean hasExternalReference(CodeUnit codeUnit) {
        Reference[] references;
        for (Reference ref : references = this.program.getReferenceManager().getReferencesFrom(codeUnit.getMinAddress())) {
            if (!ref.isExternalReference()) continue;
            return true;
        }
        return false;
    }

    private void readOptions() {
        ToolOptions options = this.tool.getOptions(OPTIONS_NAME);
        options.addOptionsChangeListener((OptionsChangeListener)this);
        this.instructionColor = options.getColor("Instruction Color", (Color)DEFAULT_INSTRUCTION_COLOR);
        this.dataColor = options.getColor("Data Color", (Color)DEFAULT_DATA_COLOR);
        this.functionColor = options.getColor("Function Color", (Color)DEFAULT_FUNCTION_COLOR);
        this.undefinedColor = options.getColor("Undefined Color", (Color)DEFAULT_UNDEFINED_COLOR);
        this.uninitializedColor = options.getColor("Uninitialized Color", (Color)DEFAULT_UNINITIALIZED_COLOR);
        this.externalRefColor = options.getColor("External Reference Color", (Color)DEFAULT_EXTERNAL_REF_COLOR);
    }

    private void registerOptions() {
        ToolOptions options = this.tool.getOptions(OPTIONS_NAME);
        HelpLocation help = new HelpLocation("OverviewPlugin", "OverviewOptions");
        options.registerThemeColorBinding("Instruction Color", DEFAULT_INSTRUCTION_COLOR.getId(), help, "Color for instructions");
        options.registerThemeColorBinding("Data Color", DEFAULT_DATA_COLOR.getId(), help, "Color for data");
        options.registerThemeColorBinding("Function Color", DEFAULT_FUNCTION_COLOR.getId(), help, "Color for functions");
        options.registerThemeColorBinding("Undefined Color", DEFAULT_UNDEFINED_COLOR.getId(), help, "Color for undefined bytes");
        options.registerThemeColorBinding("Uninitialized Color", DEFAULT_UNINITIALIZED_COLOR.getId(), help, "Color for uninitialize memory");
        options.registerThemeColorBinding("External Reference Color", DEFAULT_EXTERNAL_REF_COLOR.getId(), help, "Color for external references");
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.readOptions();
        if (this.overviewComponent != null) {
            this.overviewComponent.refreshAll();
        }
        if (this.legendPanel != null) {
            this.legendPanel.updateColors();
        }
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        for (int i = 0; i < ev.numRecords(); ++i) {
            ProgramChangeRecord record;
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            EventType eventType = doRecord.getEventType();
            if (eventType == ProgramEvent.FUNCTION_ADDED) {
                record = (ProgramChangeRecord)doRecord;
                Function function = (Function)record.getObject();
                AddressSetView addresses = function.getBody();
                this.overviewComponent.refresh(addresses.getMinAddress(), addresses.getMaxAddress());
                continue;
            }
            if (eventType == ProgramEvent.FUNCTION_REMOVED) {
                AddressSetView addresses = (AddressSetView)doRecord.getOldValue();
                this.overviewComponent.refresh(addresses.getMinAddress(), addresses.getMaxAddress());
                continue;
            }
            if (!(doRecord instanceof ProgramChangeRecord)) continue;
            record = (ProgramChangeRecord)doRecord;
            this.overviewComponent.refresh(record.getStart(), record.getEnd());
        }
    }

    private DialogComponentProvider getLegendDialog() {
        if (this.legendPanel == null) {
            this.legendPanel = new AddressTypeOverviewLegendPanel(this);
        }
        OverviewColorLegendDialog legendDialog = new OverviewColorLegendDialog("Overview Legend", this.legendPanel, this.getHelpLocation());
        return legendDialog;
    }

    private String getBlockName(Address address) {
        MemoryBlock block = this.program.getMemory().getBlock(address);
        if (block != null) {
            return block.getName();
        }
        return "";
    }

    @Override
    public Program getProgram() {
        return this.program;
    }
}

