/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.interpreter;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.widgets.FindDialog;
import docking.widgets.OptionDialog;
import docking.widgets.search.FindDialogSearcher;
import docking.widgets.search.TextComponentSearcher;
import generic.theme.GIcon;
import ghidra.app.plugin.core.interpreter.InterpreterConnection;
import ghidra.app.plugin.core.interpreter.InterpreterConsole;
import ghidra.app.plugin.core.interpreter.InterpreterPanel;
import ghidra.app.plugin.core.interpreter.InterpreterPanelPlugin;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import resources.Icons;
import utility.function.Callback;

public class InterpreterComponentProvider
extends ComponentProviderAdapter
implements InterpreterConsole {
    private InterpreterPanel panel;
    private InterpreterConnection interpreter;
    private List<Callback> firstActivationCallbacks;
    private FindDialog findDialog;

    public InterpreterComponentProvider(InterpreterPanelPlugin plugin, InterpreterConnection interpreter, boolean visible) {
        super(plugin.getTool(), interpreter.getTitle(), interpreter.getTitle());
        this.panel = new InterpreterPanel(plugin.getTool(), interpreter);
        this.interpreter = interpreter;
        this.firstActivationCallbacks = new ArrayList<Callback>();
        this.setHelpLocation(new HelpLocation(this.getName(), "interpreter"));
        this.addToTool();
        this.createActions();
        Icon icon = interpreter.getIcon();
        if (icon == null) {
            icon = new GIcon("icon.plugin.interpreter.provider");
        }
        this.setIcon(icon);
        this.setVisible(visible);
    }

    private void createActions() {
        DockingAction clearAction = new DockingAction("Clear Interpreter", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                InterpreterComponentProvider.this.clear();
            }
        };
        clearAction.setDescription("Clear Interpreter");
        clearAction.setToolBarData(new ToolBarData(Icons.CLEAR_ICON, null));
        clearAction.setEnabled(true);
        this.addLocalAction((DockingActionIf)clearAction);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Find", this.getOwner()).keyBinding("Ctrl F")).sharedKeyBinding()).helpLocation(new HelpLocation("ConsolePlugin", "Console_Find"))).popupMenuPath(new String[]{"Find..."})).onAction(c -> this.showFindDialog())).buildAndInstallLocal((ComponentProvider)this);
    }

    private void showFindDialog() {
        if (this.findDialog == null) {
            JTextPane textPane = this.panel.getOutputTextPane();
            TextComponentSearcher searcher = new TextComponentSearcher((JEditorPane)textPane);
            this.findDialog = new FindDialog("Intepreter Find", (FindDialogSearcher)searcher);
        }
        this.getTool().showDialog((DialogComponentProvider)this.findDialog);
    }

    @Override
    public void addAction(DockingAction action) {
        this.addLocalAction((DockingActionIf)action);
    }

    @Override
    public void setTransient() {
        DockingAction disposeAction = new DockingAction("Remove Interpreter", this.getName()){

            public void actionPerformed(ActionContext context) {
                int choice = OptionDialog.showYesNoDialog((Component)InterpreterComponentProvider.this.panel, (String)"Remove Interpreter?", (String)"Are you sure you want to permanently close the interpreter?");
                if (choice == 2) {
                    return;
                }
                InterpreterComponentProvider.this.dispose();
            }
        };
        disposeAction.setDescription("Remove interpreter from tool");
        disposeAction.setToolBarData(new ToolBarData(Icons.STOP_ICON, null));
        disposeAction.setEnabled(true);
        this.addLocalAction((DockingActionIf)disposeAction);
    }

    public String getWindowSubMenuName() {
        return this.interpreter.getTitle();
    }

    public String getTitle() {
        return this.interpreter.getTitle();
    }

    public String getSubTitle() {
        return "Interpreter";
    }

    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public void clear() {
        this.panel.clear();
        if (this.findDialog != null) {
            this.findDialog.close();
        }
    }

    @Override
    public InputStream getStdin() {
        return this.panel.getStdin();
    }

    @Override
    public OutputStream getStdOut() {
        return this.panel.getStdOut();
    }

    @Override
    public OutputStream getStdErr() {
        return this.panel.getStdErr();
    }

    @Override
    public PrintWriter getOutWriter() {
        return this.panel.getOutWriter();
    }

    @Override
    public PrintWriter getErrWriter() {
        return this.panel.getErrWriter();
    }

    public String getPrompt() {
        return this.panel.getPrompt();
    }

    @Override
    public void setPrompt(String prompt) {
        this.panel.setPrompt(prompt);
    }

    public void dispose() {
        this.removeFromTool();
        this.panel.dispose();
    }

    public void componentActivated() {
        ArrayList<Callback> callbacks = new ArrayList<Callback>(this.firstActivationCallbacks);
        this.firstActivationCallbacks.clear();
        callbacks.forEach(l -> l.call());
    }

    @Override
    public void addFirstActivationCallback(Callback activationCallback) {
        this.firstActivationCallbacks.add(activationCallback);
    }

    @Override
    public boolean isInputPermitted() {
        return this.panel.isInputPermitted();
    }

    @Override
    public void setInputPermitted(boolean permitted) {
        this.panel.setInputPermitted(permitted);
    }

    @Override
    public void show() {
        this.tool.showComponentProvider((ComponentProvider)this, true);
    }

    @Override
    public void updateTitle() {
        this.tool.updateTitle((ComponentProvider)this);
    }

    public String getOutputText() {
        return this.panel.getOutputText();
    }
}

