/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.list.GListCellRenderer;
import ghidra.program.model.lang.Register;
import java.util.ArrayList;
import java.util.List;
import javax.help.UnsupportedOperationException;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;

public class RegisterDropDownSelectionDataModel
implements DropDownTextFieldDataModel<Register> {
    private List<Register> registers;

    public RegisterDropDownSelectionDataModel(List<Register> registers) {
        this.registers = registers;
    }

    public List<DropDownTextFieldDataModel.SearchMode> getSupportedSearchModes() {
        return List.of(DropDownTextFieldDataModel.SearchMode.STARTS_WITH);
    }

    public ListCellRenderer<Register> getListRenderer() {
        return new GListCellRenderer();
    }

    public String getDescription(Register value) {
        return null;
    }

    public String getDisplayText(Register value) {
        return value.getName();
    }

    public List<Register> getMatchingData(String searchText) {
        throw new UnsupportedOperationException("Method no longer supported.  Instead, call getMatchingData(String, SearchMode)");
    }

    public List<Register> getMatchingData(String searchText, DropDownTextFieldDataModel.SearchMode searchMode) {
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return this.registers;
        }
        if (searchMode != DropDownTextFieldDataModel.SearchMode.STARTS_WITH) {
            throw new IllegalArgumentException("Unsupported SearchMode: " + String.valueOf(searchMode));
        }
        searchText = searchText.toLowerCase();
        ArrayList<Register> regList = new ArrayList<Register>();
        for (Register reg : this.registers) {
            String regName = reg.getName().toLowerCase();
            if (!regName.startsWith(searchText)) continue;
            regList.add(reg);
        }
        return regList;
    }

    public int getIndexOfFirstMatchingEntry(List<Register> data, String searchText) {
        String lcSearchText = searchText.toLowerCase();
        int len = data.size();
        for (int i = 0; i < len; ++i) {
            String name = data.get(i).getName();
            String lcName = name.toLowerCase();
            if (!lcName.startsWith(lcSearchText)) continue;
            return i;
        }
        return 0;
    }
}

